﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestAddWorkingOrder
    {
        [Required(ErrorMessage = "lineNotNull")]
        public int line { get; set; }

        [Required(ErrorMessage = "产品编号不能为空")]
        public string product_serial { get; set; }

        public string name { get; set; }

        [Required(ErrorMessage = "物料不能为空")]
        public string materials_pn { get; set; }

        [Required(ErrorMessage = "categoryNotNull")]
        public string category { get; set; }

        public string order_no { get; set; }

        public int quantity { get; set; }

        public int is_autoserial { get; set; }

        public int TransDateTime { get; set; }
    }

    public class RequestUpdateWorkingOrder : RequestAddWorkingOrder
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }
}
