﻿namespace Siger.Middlelayer.AccRepository.Response
{
    public class ResponeBaseItem
    {
        public int Line { get; set; }
        public int Station { get; set; }
        public TraceBaseItem TraceBaseItem { get; set; }
        public PackingBaseItem PackingBaseItem { get; set; }
    }
    public class TraceBaseItem
    {
        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }
        public TraceItems Trace { get; set; }
    }
    public class TraceItems
    {
        /// <summary>
        /// 机加工 
        /// </summary>
        public bool TrackMachine { get; set; }
        /// <summary>
        /// 保存追溯不需要检查SN 不更新过站状态
        /// </summary>
        public bool TrackNoSn { get; set; }
        /// <summary>
        /// 根据sn查询mongodb原始数据
        /// </summary>
        public bool TraceMongoDBSN { get; set; }

        /// <summary>
        /// 保存粗材号
        /// </summary>
        public bool SaveCoarse { get; set; }

        /// <summary>
        /// 创建SN 保存OP10,OP20粗材状态
        /// </summary>
        public bool SaveResultCreateSn { get; set; }

        /// <summary>
        /// 虚拟SN 追溯
        /// </summary>
        public bool SaveVSN { get; set; }

        /// <summary>
        /// 追踪非数采设备状态
        /// </summary>
        public bool NoCollectionMachineState { get; set; }

        /// <summary>
        ///  刻印使用粗材号 寿命
        /// </summary>
        public bool UseCoarseLifeCreaetSn { get; set; }
        /// <summary>
        /// 不允许调试件过站
        /// </summary>
        public bool NotAllowDebugSn { get; set; }
        /// <summary>
        /// 保存过站信息前插入SN list
        /// </summary>
        public bool CreateSNbeforeSaveTrace { get; set; }

        /// <summary>
        /// 收集清洗机数据
        /// </summary>
        public bool ClearDataCollection { get; set; }
        /// <summary>
        /// 追踪机加工SectionID
        /// </summary>
        public bool GetSectionID { get; set; }
        /// <summary>
        /// 过站不首件检
        /// </summary>
        public bool TrackNoFirstCheck { get; set; }

    }
    public class PackingBaseItem
    {
        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }
        public PackingItems Packing { get; set; }
    }
    public class PackingItems
    {
        /// <summary>
        /// 打包不需要检查SN 不更新过站状态
        /// </summary>
        public bool Packing_NoCheckSn { get; set; }
        public bool Packing_NotAllowDebugSn { get; set; }

    }
}
