﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Response
{
    public class ResponseGeneralTrackingDts
    {
        public string Sn { get; set; }
        public int Section { get; set; }
        public string Station { get; set; }
        public string Uid { get; set; }
        public string Result { get; set; }
        public string Item { get; set; }
        public string Values { get; set; }
        public DateTime Time { get; set; }
    }
    public class GeneralReport
    {
        public SnTracking Header { get; set; }
        public List<ResponseGeneralTrackingDts> Body { get; set; }
    }
    public class SnTracking
    {
        public string Sn { get; set; }
        public List<TrackingStation> Stations { get; set; }
    }
    public class TrackingStation
    {
        /// <summary>
        /// 工站ID
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// 工站名称
        /// </summary>
        public string Station { get; set; }
        public List<ItemDts> Details { get; set; }

    }


    public class ItemDts
    {
        public string Item { get; set; }
        public string Values { get; set; }
    }
    public class HeaderStation
    {
        public int Seq { get; set; }
        public int Station { get; set; }
        public string Title { get; set; }
    }
    public class GeneralDtlSn
    {
        public int Line { get; set; }
        public int Station { get; set; }
        public string Sn { get; set; }
        public string Pn { get; set; }
        public string ProductId { get; set; }
        public DateTime Transdate { get; set; }
        public string Result { get; set; }
        public int Status { get; set; }
    }
    public class GeneralDtlSnContent
    {
        public string Sn { get; set; }
        public int Station { get; set; }
        public DateTime TransDateTime { get; set; }
        public string Uid { get; set; }
        public string Result { get; set; }
        public string Item { get; set; }
        public string Values { get; set; }
    }
    public class GeneralTrackingSn
    {
        public List<TrackingSnStation> Heads { get; set; }

        public List<TrackingSnStation> Bodys { get; set; }
    }

    public class TrackingSnStationUI
    {
        public int RowNo { get; set; }
        public List<TrackingSnStation> RowsCols { get; set; }
    }

    public class GeneralTrackingSnResult
    {
        public List<TrackingSnStation> Heads { get; set; }
        public List<TrackingSnStationUI> Bodys { get; set; }
        public GeneralTrackingSnResult()
        {
            Heads = new List<TrackingSnStation>();
            Bodys = new List<TrackingSnStationUI>();
        }
    }
    public class TrackingSnStation
    {
        public int Row { get; set; }
        public string Sn { get; set; }
        public int Section { get; set; }
        public string Station { get; set; }
        public List<ItemDts> Items { get; set; }

        public string ProductCode { get; set; }
        public string ProductNmae { get; set; }

        public string spec { get; set; }
        /// <summary>
        /// 生产线
        /// </summary>
        public string Line { get; set; }

        public string WO { get; set; }
        /// <summary>
        /// 工单数量
        /// </summary>
        public int install_count { get; set; }
        /// <summary>
        /// 订单
        /// </summary>
        public string ordernumber { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int quantity { get; set; }
        
        /// <summary>
        /// 订单交期
        /// </summary>
        public int delivery_time { get; set; }
    }

    public class ResponseSnList
    {
        public string Sn { get; set; }
        public string ProductCode { get; set; }
        public string ProductNmae { get; set; }

        public string spec { get; set; }
        /// <summary>
        /// 生产线
        /// </summary>
        public string Line { get; set; }

        public string WO { get; set; }
        /// <summary>
        /// 工单数量
        /// </summary>
        public int install_count { get; set; }
        /// <summary>
        /// 订单
        /// </summary>
        public string ordernumber { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int quantity { get; set; }

        /// <summary>
        /// 订单交期
        /// </summary>
        public int delivery_time { get; set; }
    }

}
