﻿using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Response
{
    public class ResponseProductInfo
    {
        public int ID { get; set; } 
        public string ProductId { get; set; }
    }
    public class ResponseProductCode
    {
        public string SN { get; set; }
        public string PN { get; set; }

        public string WO { get; set; }
        public int productId { get; set; }
        public string productCode { get; set; }
        public string drawingcode { get; set; }
        public int number { get; set; }
        public int sum { get; set; }
    }

    public class ResponseRoute
    {
        public int ID { get; set; }
        public string name { get; set; }
    }
    public class ResponseMateNumber
    {
        public int number { get; set; }
    }

    /// <summary>
    /// 基本信息
    /// </summary>
    public class ResponseProduct
    {
        public string name { get; set; }
        public string sn { get; set; }
        public string WO { get; set; }
        public string PN { get; set; }
        public string drawingcode { get; set; }
        public  string dateTime { get; set; }
        public List<ResponseAssembling> AssembList { get; set; }

        public List<ResponseInspectionData> InspectionData { get; set; }
    }
    /// <summary>
    /// 装配信息
    /// </summary>
    public class ResponseAssembling
    {
        public string name { get; set; }

        public string drawingcode { get; set; }
        public DateTime dateTime { get; set; }

        public string number { get; set; }

        public string batch { get; set; }//辅料的序号

        public string UID{ get; set; }
        public string ProductRoute { get; set; }
        public string section { get; set; }

        public int type { get; set; }
    }
    /// <summary>
    /// 检验数据
    /// </summary>
    public class ResponseInspectionData
    {
        public string name { get; set; }

        public string drawingcode { get; set; }
        public DateTime dateTime { get; set; }

        public int number { get; set; }

        public string batch { get; set; }//辅料的序号

        public string section { get; set; }

        public string result { get; set; }//检验结果

        public string UID { get; set; }

        public string checkType { get; set; }

        public string ProductRoute { get; set; }
        public List<RequestTraceDetial> TraceDetials { get; set; }
    }

}
