﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.CncRepository
{
    public class ApiCncDbContext : DbContext
    {
        public ApiCncDbContext()
        {

        }

        public ApiCncDbContext(DbContextOptions<ApiCncDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_project_section> siger_project_section { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_machine_param_alarm> siger_project_machine_param_alarm { get; set; }
        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }
        public DbSet<Entities.siger_project_product_plan> siger_project_product_plan { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }
        public DbSet<siger_project_product_report> siger_project_product_report { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<siger_project_production_time> siger_project_production_time { get; set; }
        public DbSet<siger_project_beat_set> siger_project_beat_set { get; set; }
        public DbSet<siger_project_machine_wordingmode> siger_project_machine_wordingmode { get; set; }

        public DbSet<siger_project_production_allocation> siger_project_production_allocation { get; set; }

        public DbSet<siger_project_produce_schedule> siger_project_produce_schedule { get; set; }

        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }
        public DbSet<siger_project_product_plan_detail> siger_project_product_plan_detail { get; set; }
        public DbSet<siger_project_machine_status_timesetting> siger_project_machine_status_timesetting { get; set; }

        public DbSet<siger_project_machine_fault_type> siger_project_machine_fault_type { get; set; }

        public DbSet<siger_project_monthreport_config> siger_project_monthreport_config { get; set; }
        public DbSet<siger_project_monthreport_sendrecord> siger_project_monthreport_sendrecord { get; set; }
        public DbSet<SigerProjectEmailConfig> siger_project_email_config { get; set; }

        public DbSet<siger_project_produce_efficiency> siger_project_produce_efficiency { get; set; }

        public DbSet<siger_project_working_group> siger_project_working_group { get; set; }
        public DbSet<siger_project_working_sign> siger_project_working_sign { get; set; }
        public DbSet<siger_project_working_machine_states> siger_project_working_machine_states { get; set; }
        public DbSet<siger_project_working_machine_current_state> siger_project_working_machine_current_state { get; set; }

        public DbSet<siger_project_shift> siger_project_shift { get; set; }
        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }
        public DbSet<siger_project_user_group> siger_project_user_group { get; set; }
        public DbSet<siger_project_station> siger_project_station { get; set; }
        public DbSet<siger_project_wo_trace> siger_tr_wo_trace { get; set; }
        public DbSet<siger_project_wo_trace_details> siger_tr_wo_trace_detail { get; set; }

        public DbSet<SigerTrBasketlist> siger_tr_basketlist { get; set; }

        public DbSet<siger_tr_basketful_position> siger_tr_basketful_position { get; set; }
        public DbSet<SigerTrBaseSetting> siger_tr_station_base_setting { get; set; }

        public DbSet<siger_project_product_plan_change> siger_project_product_plan_change { get; set; }

        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<siger_project_order_type> siger_project_order_type { get; set; }
        public DbSet<siger_project_dashboard_fixpath> siger_project_dashboard_fixpath { get; set; }

        public DbSet<siger_project_box> siger_project_box { get; set; }
        public DbSet<siger_project_dashboard_comb_page_condition> siger_project_dashboard_comb_page_condition { get; set; }

        public DbSet<siger_project> siger_project { get; set; }
        public DbSet<siger_company> siger_company { get; set; }
        public DbSet<siger_project_product_plan_change_record> siger_project_product_plan_change_record { get; set; }
        public DbSet<siger_project_product_plan_dispatch> siger_project_product_plan_dispatch { get; set; }
        public DbSet<siger_project_product_plan_out_dispatch> siger_project_product_plan_out_dispatch { get; set; }

        public DbSet<siger_project_production_time_allocation> siger_project_production_time_allocation { get; set; }
        public DbSet<siger_project_cj_machine> siger_project_cj_machine { get; set; }
        public DbSet<siger_project_rest_type> siger_project_rest_type { get; set; }

        public DbSet<siger_project_clock_record> siger_project_clock_record { get; set; }
        public DbSet<siger_project_machine_clock> siger_project_machine_clock { get; set; }
        

        public DbSet<siger_project_clock_record_ttl> siger_project_clock_record_ttl { get; set; }

        public DbSet<siger_projectId_plan_machine_route> siger_projectId_plan_machine_route { get; set; }
        
        public DbSet<siger_project_esop_document> siger_project_esop_document { get; set; }

        public DbSet<siger_project_esop_document_history> siger_project_esop_document_history { get; set; }



    }
}
 