﻿using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Request;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface IProduceScheduleRepository : ICncRepositoryBase<siger_project_produce_schedule>
    {
        IEnumerable<ResponseGetProductRouteInfo> GetRoutes(int productId, int sectionId, int projectId);

        IEnumerable<ResponseGetCrashList> GetCrashLists(int sectionId, int projectId);

        IEnumerable<GetMachineGanteInfo> GetMachineGante(int sectionId, int projectId);

        bool AddChangLingSchedule(RequestChanglingAddSchedule request, siger_project_product_plan plan, int projectId);

        IEnumerable<ResponsePlanJob> GetResponsePlanJob(int planId, int projectId);
    }
}
