﻿using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface ISigerProjectClockRecord: ICncRepositoryBase<siger_project_clock_record>
    {
        IPagedCollectionResult<ReponseRecord> GetPagedRecord(string stationline, string starttime, string endtime,int section,int shift, int users,int page,int pagesize,int pid);
        IEnumerable<ReponseRecord> GetClockRecordPopup(int userId, int projectId);
 
        IPagedCollectionResult<ResponseAchieveTotal> GetAchieveMentTotal(DateTime starttime, DateTime endtime, int section, int shift, int user_id, int projectId, int page, int pagesize);


        /// <summary>
        /// 获取时间段内人员签到信息
        /// </summary>
        /// <param name="starttime"></param>
        /// <param name="endtime"></param>
        /// <param name="shift"></param>
        /// <param name="user_id"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<ResponseClockDets> GetClockDetails(DateTime starttime, DateTime endtime, int shiftid,int user_id, int projectId);

    }
}
