﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Share.Models;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class ProductionTimeRepository : CncRepositoryBase<siger_project_production_time>, IProductionTimeRepository
    {
        private readonly ApiCncDbContext _context;
        public ProductionTimeRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseTimeAllSettingShow> GetPagedList(int sectionid, int projectId, int page,
            int pagesize)
        {
            var queryList = from q in _context.siger_project_production_time
                join u in _context.siger_project_user on q.founder equals u.mid.ToString() into temp
                from us in temp.DefaultIfEmpty()
                where q.projectid == projectId && q.status == (int) RowState.Valid  orderby q.add_time descending
                select new ResponseTimeAllSettingShow
                {
                    id = q.id,
                    add_time = q.add_time.ToString(ParameterConstant.DateTimeFormat),
                    bing_time = q.bing_time,
                    end_time = q.end_time,
                    founder = q.founder,
                    founderName = us != null ? us.name : "",
                    machineid = q.machineid,
                    projectid = q.projectid,
                    sectionid = q.sectionid,
                    type = q.type,
                    status = q.status,
                    typeid = q.typeid
                };
            if (sectionid != 0)
            {
                var sectionIds = GetLevelSectionIds(sectionid, projectId);
                queryList = queryList.Where(q => sectionIds.Contains(q.sectionid));
            }

            var totalCount = queryList.Count();
            var entities = queryList.Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<ResponseTimeAllSettingShow>(entities, totalCount);
        }

        public IEnumerable<MachineRestInfo> GetRestTimesByMachine(IEnumerable<int> machineIds, int projectId)
        {
            var result = new List<MachineRestInfo>();
            foreach (var machineId in machineIds)
            {
                var times = _context.siger_project_production_time.Where(m =>
                    m.machineid == machineId && m.status == (int)RowState.Valid && m.projectid == projectId).ToList();
                foreach (var time in times)
                {
                    result.Add(new MachineRestInfo
                    {
                        BingTime = time.bing_time,
                        EndTime = time.end_time,
                        MachineId = machineId,
                        SectionId = time.sectionid,
                        TimeType = (TimeType)time.typeid
                    });
                }
            }

            return result;
        }
    }
}
