﻿using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Siger.Middlelayer.Common;
using System.Linq.Expressions;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Extensions;
using Microsoft.EntityFrameworkCore;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class SigerProjectBoxRepository : CncRepositoryBase<siger_project_box>, ISigerProjectBoxRepository
    {
        private readonly ApiCncDbContext _context;
        public SigerProjectBoxRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<MachineBox> GetPageMachineGetBox(MachineGetBox request)
        {
            var query = from a in _context.siger_project_box
                        join b in _context.siger_project_machine on a.machineid equals b.id into bb
                        from b in bb.DefaultIfEmpty()
                        join c in _context.siger_project on a.pid equals c.id into cc
                        from c in cc.DefaultIfEmpty()
                        join d in _context.siger_company on a.cid equals d.id into dd
                        from d in dd.DefaultIfEmpty()
                        where a.status == (int)RowState.Valid 
                        select new MachineBox
                        {
                            id=a.id,
                            boxCode=a.boxcode,
                            pid=c!=null?c.id:0,
                            title= c != null ? c.title:"",
                            cid= d != null ? d.id:0,
                            chinesepinyin= d != null ? d.chinesename:"",
                            enableTime=a.enableTime!=null? a.enableTime.ToString(ParameterConstant.DateFormat):"",
                            usageStatus= a.usage_status,
                            system=a.system,
                            program_version=a.program_version,
                            mid=a.machineid,
                            mcode= b != null ? b.code:"",
                            mandate_endTime = a.mandateType > 1 ? (a.enableTime != null ? a.enableTime.AddDays(a.mandate_days).ToString(ParameterConstant.DateFormat) : "") : "",
                            model= b != null ? b.model:"",
                            mandateType=a.mandateType
                        };
            var ss = query.ToList();
            Expression<Func<MachineBox, bool>> boxCodeExpression = q => true;
            if (!string.IsNullOrWhiteSpace(request.boxCode))
            {
                boxCodeExpression = q => q.boxCode.Contains(request.boxCode);
            }
            Expression<Func<MachineBox, bool>> pidExpression = q => true;
            if (!string.IsNullOrWhiteSpace(request.pid.ToStr())&& request.pid>0)
            {
                pidExpression = q => q.pid== request.pid;
            }
            Expression<Func<MachineBox, bool>> usageStatusExpression = q => true;
            if (!string.IsNullOrWhiteSpace(request.usageStatus.ToStr()) && request.usageStatus>-1)
            {
                usageStatusExpression = q => q.usageStatus== request.usageStatus;
            }
            Expression<Func<MachineBox, bool>> EnableTimeExpression = q => true;
            if (!string.IsNullOrWhiteSpace(request.EnableTime))
            {
                string[] time = request.EnableTime.Split(',');
                if (time.Length==2)
                {
                    EnableTimeExpression = q => q.enableTime.ToDateTime() >= time[0].ToDateTime() && q.enableTime.ToDateTime() <= time[1].ToDateTime();
                }
            }
            Expression<Func<MachineBox, bool>> midExpression = q => true;
            if (request.mid >0)
            {
                midExpression = q => q.mid == request.mid;
            }
            Expression<Func<MachineBox, bool>> projectIdExpression = q => true;
            if (request.projectId > 0)
            {
                projectIdExpression = q => q.pid == request.projectId;
            }
            var predicate = boxCodeExpression.And(pidExpression).And(usageStatusExpression).And(EnableTimeExpression).And(midExpression).And(projectIdExpression);
            var totalCount = query.Count(predicate);
            var entities = query.Where(predicate).Skip((request.page - 1) * request.pagesize).Take(request.pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<MachineBox>(entities, totalCount);
        }
    }
}
