﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Data.Acc;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class WorkingStateRepository : CncRepositoryBase<siger_project_working_machine_states>, IWorkingStateRepository
    {
        private readonly ApiCncDbContext _context;
        public WorkingStateRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<BasketList> GetBasketlist(string number, int projectid)
        {
            Expression<Func<BasketList, bool>> funNum = f => true;
            var query = from s in _context.siger_tr_basketlist
                join p in _context.siger_tr_basketful_position on s.traceId equals p.traceid
                where s.projectId == projectid
                select new BasketList
                {
                    id = s.id,
                    BasketNumber = s.number,
                    Count = s.count,
                    WorkCode = p.workcode,
                    PrdNumber = p.productbh,
                    PrdtName = p.productname,
                    ModelType = p.producttype,
                    OrderCode = p.orderno                    
                };
            if (!string.IsNullOrEmpty(number))
            {
                funNum = q => q.BasketNumber.Equals(number);
            }
            var entities = query.Where(funNum).ToList();
            return entities;
        }
    }
}
