﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Request
{
    /// <summary>
    /// 计划内派工接收参数
    /// </summary>
    public class RequestProductPlanDispatch
    {
        public int id { get; set; }
        /// <summary>
        /// 计划ID
        /// </summary>
        public int planId { get; set; }

        public IEnumerable<DispatchDetails> orders { get; set; }
    }

    public class DispatchDetails
    {
        /// <summary>
        /// 工令单号
        /// </summary>
        public string orderNumber { get; set; }

        /// <summary>
        /// 批次数量
        /// </summary>
        public int count { get; set; }
    }

    public class RequestMachine
    {
        public string title { get; set; }
        public int machineId { get; set; }
        public int sectionId { get; set; }
        /// <summary>
        /// 0:未绑定  1：已绑定
        /// </summary>
        public int state { get; set; }
        public int status { get; set; }
        public int section { get; set; }
    }

    public class RequestMachines : RequestMachine
    {
        public int id { get; set; }
        public int product_id { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string producename { get; set; }
        /// <summary>
        /// 图纸号
        /// </summary>
        public string drawnumber { get; set; }
        /// <summary>
        /// 工单号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 订单数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 交付日期
        /// </summary>
        public string deliverytime { get; set; }
        /// <summary>
        /// 工令号
        /// </summary>
        public string circulation { get; set; }
        /// <summary>
        /// 工序码
        /// </summary>
        public string route_ordernumber { get; set; }
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// OK数量
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// nok数量
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 已报工数量
        /// </summary>
        public int number { get; set; }

        /// <summary>
        /// 图纸地址
        /// </summary>
        public string draw_url { get; set; } = string.Empty;

        public int sectionId { get; set; }
        public int section { get; set; }
    }

    public class RequestReworkMachines : RequestMachine
    {
        public int id { get; set; }
        public int product_id { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string producename { get; set; }
        /// <summary>
        /// 图纸号
        /// </summary>
        public string drawnumber { get; set; }
        /// <summary>
        /// 工单号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 返工数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 开单日期
        /// </summary>
        public string deliverytime { get; set; }
        /// <summary>
        /// 工令号
        /// </summary>
        public string circulation { get; set; }
        /// <summary>
        /// 工序码
        /// </summary>
        public string route_ordernumber { get; set; }
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// OK数量
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// nok数量
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 已报工数量
        /// </summary>
        public int number { get; set; }
    }
    public class Requestup
    {
        /// <summary>
        /// 工令单表id
        /// </summary>
        public int planDetailId { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int machineId { get; set; }
    }

    public class RequestStart
    {
        /// <summary>
        /// 工序码
        /// </summary>
        public string route_code { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int machineId { get; set; }
        /// <summary>
        /// section
        /// </summary>
        public int sectionId { get; set; }


    }
    public class RequestReportPreservation
    {
        /// <summary>
        /// id
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 生产数量
        /// </summary>
        public int product_number { get; set; }
        /// <summary>
        /// OK数量
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// nok数量
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int machineId { get; set; }
        /// <summary>
        /// 0:确认 1：完工 2:完工的未完工
        /// </summary>
        public int IsComplete { get; set; }
        /// <summary>
        /// 程序号
        /// </summary>
        public string ProgramCode { get; set; }

        public int uid { get; set; }
        /// <summary>
        /// 工序码
        /// </summary>
        public string route_ordernumber { get; set; }

        public string startTime { get; set; }

        public string endTime { get; set; }

        public int sectionId { get; set; }

    }

    public class RequestProgram
    {
        /// <summary>
        /// 设备id
        /// </summary>
        public int machineId { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public int route_id { get; set; }
    }

    public class RequestPrograms
    {

        public string ProgramCode { get; set; }
        public string startTime { get; set; }

        public string endTime { get; set; }

        public int number { get; set; }
    }
    public class RequestReport
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 工令号
        /// </summary>
        public string orderNumber { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 报工人员
        /// </summary>
        public string uid { get; set; }

        public string startTime { get; set; }

        public string endTime { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public string state { get; set; }
        public int page { get; set; }
        public int pagesize { get; set; }
    }
}
