﻿using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.CncRepository.Response
{
    public class ResponseMachineAlarmDetail
    {
        public string AlarmCode { get; set; }

        public string AlarmContent { get; set; }

        public string EndTime { get; set; }

        public string FaultType { get; set; }

        public int MachineId { get; set; }

        public string StartTime { get; set; }

        public string active { get; set; }

        public string fault_content { get; set; }

        public string fault_reason { get; set; }

        public string fault_solution { get; set; }

        public int row_count { get; set; }

        public int section_id { get; set; }

        public string section_name { get; set; }

        public string station_name { get; set; }

        public string time_span { get; set; }
    }

    public class MachineAddBox
    {
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string boxCode { get; set; }
        /// <summary>
        /// 适配数控系统
        /// </summary>
        public string system { get; set; }
        /// <summary>
        /// 版本
        /// </summary>
        public string program_version { get; set; }

    }

    public class MachineBoxStatus
    {
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string boxCode { get; set; }
        /// <summary>
        /// 使用状态
        /// </summary>
        public int usageStatus { get; set; }

    }


    public class MachineGetBox
    {
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string boxCode { get; set; }
        /// <summary>
        /// 项目id
        /// </summary>
        public int pid { get; set; }
        /// <summary>
        /// 启用时间范围
        /// </summary>
        public string EnableTime { get; set; }
        /// <summary>
        /// 使用状态
        /// </summary>
        public int usageStatus { get; set; }
        /// <summary>
        /// 设备mid
        /// </summary>
        public int mid { get; set; }

        public int projectId { get; set; }
        public int page { get; set; } = 1;

        public int pagesize { get; set; } = 10;
    }

    public class MachineBox
    {
        public int id { get; set; }
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string boxCode { get; set; }
        /// <summary>
        /// 项目id
        /// </summary>
        public int pid { get; set; }
        /// <summary>
        /// 项目名称
        /// </summary>
        public string title { get; set; }
        /// <summary>
        /// 客户id
        /// </summary>
        public int cid { get; set; }
        /// <summary>
        /// 客户名称
        /// </summary>
        public string chinesepinyin { get; set; }
        /// <summary>
        /// 启用时间
        /// </summary>
        public string enableTime { get; set; }
        /// <summary>
        /// 使用状态
        /// </summary>
        public int usageStatus { get; set; }
        /// <summary>
        /// 适配数控系统
        /// </summary>
        public string system { get; set; }
        /// <summary>
        /// 版本
        /// </summary>
        public string program_version { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int mid { get; set; }
        /// <summary>
        /// 设备 编号
        /// </summary>
        public string mcode { get; set; }
        /// <summary>
        /// 授权到期时间
        /// </summary>
        public string mandate_endTime { get; set; }
        /// <summary>
        /// 设备型号
        /// </summary>
        public string model { get; set; }
        public int mandateType { get; set; }
    }

    public class MachineMandateBox
    {
        public int id { get; set; }
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string boxCode { get; set; }
        /// <summary>
        /// 项目id
        /// </summary>
        public int pid { get; set; }
        /// <summary>
        /// 客户id
        /// </summary>
        public int cid { get; set; }
        /// <summary>
        /// 启用时间
        /// </summary>
        public string enableTime { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int mid { get; set; }
        /// <summary>
        /// 设备 编号
        /// </summary>
        public string mcode { get; set; }
        /// <summary>
        /// 授权天数
        /// </summary>
        public int mandatedays { get; set; }
        /// <summary>
        /// 授权type
        /// </summary>
        public int mandatetype { get; set; }

    }

    public class MachineMandate
    {
        /// <summary>
        /// 盒子编号
        /// </summary>s
        public string boxNo { get; set; }
        /// <summary>
        /// 项目id
        /// </summary>
        public int pid { get; set; }
        /// <summary>
        /// 客户id
        /// </summary>
        public int cid { get; set; }
        /// <summary>
        /// 启用时间
        /// </summary>
        public DateTime startDate { get; set; }
        /// <summary>
        /// 授权天数
        /// </summary>
        public int validDays { get; set; }

        public int mid { get; set; }

    }

    public class UpdateMachine
    {
        public int id { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public int machineid { get; set; }

    }

    public class MachineProjectId
    {

        public int projectId { get; set; }
    }

    public class getToken
    {

        public string loginName { get; set; }
        public string passWord { get; set; }
    }
    public class machinesLists
    {
        public string machineId { get; set; }
        public int runStatus { get; set; }
        public List<machineList> machineList { get; set; }
    }
    public class machineList
    {
        public string machineCode { get; set; }
        public string startTime { get; set; }
        public string endTime { get; set; }
    }
    public class ResponseGetValue
    {
        public int ret { get; set; }
        public string data { get; set; }
    }

    public class ResponseGetValues
    {
        public int code { get; set; }
        public string messages { get; set; }
        public List<machineStatus> data { get; set; }
    }

    public class ResponseGetStatus
    {
        public int code { get; set; }
        public string messages { get; set; }
        public List<machineStatusList> data { get; set; }
    }

    public class ResponseCommonStatus
    {
        public int code { get; set; }
        public string messages { get; set; }
    }



    public class machineStatusList
    {
        public int status { get; set; }
        
        public int duration { get; set; }
    }
    public class machineStatus
    {
        public int status { get; set; }
        public int alarmStatus { get; set; }
        public int runStatus { get; set; }
        public long? collectDate { get; set; } = 0;
        public string machineId { get; set; }
        public string machineCode { get; set; }
        public string machineName { get; set; }
        public string machineModelId { get; set; }
        public string dpuId { get; set; }
        public string project { get; set; }
        public string orgName { get; set; }
    }
}
