﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Response
{
    /// <summary>
    /// 计划内派工返回参数
    /// </summary>
    public class ResponseProductPlanDispatch
    {
        public int id { get; set; }
        public int projectid { get; set; }
        public int planid { get; set; }
		/// <summary>
		/// 产品名称
		/// </summary>
		public string product_name { get; set; }
		/// <summary>
		/// 产品编号
		/// </summary>
		public string product_code { get; set; }
		/// <summary>
		/// 订单号
		/// </summary>
		public string ordernumber { get; set; }
		/// <summary>
		/// 工单号
		/// </summary>
		public string code { get; set; }
		/// <summary>
		/// 图纸号
		/// </summary>
		public string draw_number { get; set; }
		/// <summary>
		/// 工单数量
		/// </summary>
		public int install_count  { get; set; }
		/// <summary>
		/// 已生产数据
		/// </summary>
		public int producted_number { get; set; }
		/// <summary>
		/// 已排产数量
		/// </summary>
		public int scheduled_quantity { get; set; }
		/// <summary>
		/// 交付日期
		/// </summary>
		public string delivery_time { get; set; }
		/// <summary>
		/// 剩余天数
		/// </summary>
		public int days_remaining { get; set; }
		/// <summary>
		/// 工单状态:1=未下发(生产计划使用);2=未排产；3=已派工；4=生产中；5=已完工；6=已终止
		/// </summary>
		public int workorder_status { get; set; }
		/// <summary>
		/// 计划开始时间
		/// </summary>
		public string plan_starttime { get; set; }
		/// <summary>
		/// 计划结束时间
		/// </summary>
		public string plan_endtime { get; set; }
		/// <summary>
		/// 实际完成时间
		/// </summary>
		public string actual_completiontime { get; set; }
		/// <summary>
		/// OK数量
		/// </summary>
		public int ok_number { get; set; }
		/// <summary>
		/// NOK数量
		/// </summary>
		public int nok_number { get; set; }
		/// <summary>
		/// 批数
		/// </summary>
		public int batches_number { get; set; }
		/// <summary>
		/// 完成率
		/// </summary>
		public double completion_rate { get; set; }
		/// <summary>
		/// 新增时间
		/// </summary>
		public string create_time { get; set; }
	}
	/// <summary>
	/// 派工弹框数据类
	/// </summary>
	public class ResponseDispatchDataDetail
	{
		/// <summary>
		/// 工单数量
		/// </summary>
		public int producted_number { get; set; }
		/// <summary>
		/// 已排产数量
		/// </summary>
		public int scheduled_quantity { get; set; }
		/// <summary>
		/// 工单号
		/// </summary>
		public string code { get; set; }
		/// <summary>
		/// 产品名称
		/// </summary>
		public string product_name { get; set; }
		/// <summary>
		/// 图纸号
		/// </summary>
		public string draw_number { get; set; }
		/// <summary>
		/// 交付日期
		/// </summary>
		public string delivery_time { get; set; }
	}
	/// <summary>
	/// 工令号和派工数量
	/// </summary>
	public class WorkorderAndNumber 
	{
		/// <summary>
		/// 工令号
		/// </summary>
		public string workorderno { get; set; }
		/// <summary>
		/// 派工数量
		/// </summary>
		public int dispatchquantity { get; set; }

	}

	/// <summary>
	/// 计划内派工查看进度弹框返回值
	/// </summary>
	public class ResponseDispatchViewProgress
	{
		/// <summary>
		/// 工序顺序号
		/// </summary>
		public int serialNumber { get; set; } = 0;
		/// <summary>
		/// 工序名称
		/// </summary>
		public string name { get; set; } = string.Empty;
		/// <summary>
		/// 工序说明
		/// </summary>
		public string description { get; set; } = string.Empty;
		/// <summary>
		/// 工单数量
		/// </summary>
		public double producted_number { get; set; }
		/// <summary>
		/// 已派工数量
		/// </summary>
		public double job_count { get; set; }
		/// <summary>
		/// OK数量
		/// </summary>
		public double ok_number { get; set; }
		/// <summary>
		/// NOK数量
		/// </summary>
		public double nok_number { get; set; }
		/// <summary>
		/// 生产进度
		/// </summary>
		public double productionschedule { get; set; }
		/// <summary>
		/// 状态
		/// </summary>
		public string state { get; set; }
	}

	/// <summary>
	/// 终止弹框数据回参
	/// </summary>
	public class ResponseStopSchedule 
	{
		/// <summary>
		/// 工令单id
		/// </summary>
		public int id { get; set; }
		/// <summary>
		/// 工令单号
		/// </summary>
		public string orderNumber { get; set; }
		/// <summary>
		/// 派工人员
		/// </summary>
		public string name { get; set; }
		/// <summary>
		/// 派工时间
		/// </summary>
		public string time { get; set; }
		/// <summary>
		/// 状态
		/// </summary>
		public string state { get; set; }
		/// <summary>
		/// 工单工数量
		/// </summary>
		public int install_count { get; set; }
		/// <summary>
		/// 工令单-派工数量
		/// </summary>
		public int quantiy { get; set; }
		/// <summary>
		///  工令单-报工数量（OK+NG）
		/// </summary>
		public int producted_num { get; set; }
		/// <summary>
		/// 工令单-报工NG
		/// </summary>
		public int ngCount { get; set; }
		/// <summary>
		/// 工令单-剩余数量
		/// </summary>
		public int last_number { get; set; }
	}



}
