﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.CncRepository.Response
{
    public class ResponseGetSignMachine
    {
        public List<SignMachine> machines { get; set; }
    }

    public class SignMachine
    {
        public int machineid { get; set; }

        public string machinename { get; set; }

        public string username { get; set; }

        public string location { get; set; }
    }

    public class ResponseGetSignOutMachine
    {
        public List<SignOutMachine> mchines { get; set; }
    }

    public class SignOutMachine
    {
        public string machinecode { get; set; }

        public int machineid { get; set; }

        public string machinename { get; set; }

        public string location { get; set; }

        public string signtime { get; set; }

        public double totaltime { get; set; }
    }

    public class ResponseGetSignRecord
    {
        public string location { get; set; }

        public string workcode { get; set; }

        public string username { get; set; }

        /// <summary>
        /// 部门
        /// </summary>
        public string departname { get; set; }

        /// <summary>
        /// 岗位
        /// </summary>
        public string stationname { get; set; }

        /// <summary>
        /// 班组
        /// </summary>
        public string groupname { get; set; }

        public string startworktime { get; set; }

        public string endworktime { get; set; }

        public double totaltime { get; set; }

        public int machineid { get; set; }
    }

    public class GetSignRecords : ResponseGetSignRecord
    {
        public DateTime signintime { get; set; }

        public DateTime signouttime { get; set; }

        public int userid { get; set; }

        public int departid { get; set; }

        /// <summary>
        /// 班组
        /// </summary>
        public List<int> workgroupids { get; set; } = new List<int>();

        public List<int> shiftids { get; set; } = new List<int>();

        public int stationid { get; set; }

        public string shiftname { get; set; }
    }

    public class UserWorkGroups
    {
        public int mid { get; set; }

        public string workgroupname { get; set; }

        public List<int> workgroupids = new List<int>();

        public List<int> shiftids { get; set; } = new List<int>();

        public string shiftname { get; set; }
    }

    public class ResponseUserWorkTimeCount
    {
        public int userid { get; set; }

        public string workcode { get; set; }

        public string username { get; set; }

        /// <summary>
        /// 部门
        /// </summary>
        public string departname { get; set; }

        /// <summary>
        /// 岗位
        /// </summary>
        public string stationname { get; set; }

        /// <summary>
        /// 班组
        /// </summary>
        public string groupname { get; set; }

        /// <summary>
        /// 作业工时
        /// </summary>
        public double worktime { get; set; }

        /// <summary>
        /// 损失工时
        /// </summary>
        public double losstime { get; set; }

        /// <summary>
        /// 实际生产工时
        /// </summary>
        public double producttime { get; set; }

        /// <summary>
        /// 有效产出工时
        /// </summary>
        public double efficiencytime { get; set; }

        /// <summary>
        /// 作业效率
        /// </summary>
        public double workefficiency { get; set; }
    }

    public class ResponsePerformanceAnalysis
    {
        public List<string> x { get; set; } = new List<string>();

        public List<double> y { get; set; } = new List<double>();

        public List<object> datalist { get; set; } = new List<object>();
    }

    public class WorkTimes
    {
        /// <summary>
        /// 序号
        /// </summary>
        public int number { get; set; }

        /// <summary>
        /// 作业工时
        /// </summary>
        public double worktime { get; set; }

        /// <summary>
        /// 损失工时
        /// </summary>
        public double losstime { get; set; }

        /// <summary>
        /// 实际生产工时
        /// </summary>
        public double producttime { get; set; }

        /// <summary>
        /// 有效产出工时
        /// </summary>
        public double efficiencytime { get; set; }

        /// <summary>
        /// 作业效率
        /// </summary>
        public double workefficiency { get; set; }
    }

    public class DateWorkTimes : WorkTimes
    {
        public string date { get; set; }
    }

    public class GroupWorkTimes : WorkTimes
    {
        public string groupname { get; set; }
    }

    public class UserWorkTimes : WorkTimes
    {
        public string username { get; set; }
    }

    public class ResponseGetUserWorkTimeDetail
    {
        public string workcode { get; set; }

        public string username { get; set; }

        public string shiftname { get; set; }

        public string timerange { get; set; }

        public List<SignCountRecord> SignRecords { get; set; } = new List<SignCountRecord>();

        public List<FaultCountRecord> FaultRecords { get; set; } = new List<FaultCountRecord>();

        public List<ReportCountRecord> ReportRecords { get; set; } = new List<ReportCountRecord>();
    }

    public class SignCountRecord
    {
        public string location { get; set; }

        public string startworktime { get; set; }

        public string endworktime { get; set; }

        public double worktime { get; set; }
    }

    public class FaultCountRecord
    {
        public string location { get; set; }

        public string faultname { get; set; }

        public string faultdetail { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }

        public double losstime { get; set; }
    }

    public class ReportCountRecord
    {
        public string location { get; set; }

        public string ordernumber { get; set; }

        public string productname { get; set; }

        public string routename { get; set; }

        public double oknumber { get; set; }

        public double noknumber { get; set; }

        public double effiencytime { get; set; }

        public string reporttime { get; set; }
    }
}
