﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Response;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.DashboardRepository.Repositories
{
    internal class DashboardCombPageConditionRepository :
        DashboardRepositoryBase<siger_project_dashboard_comb_page_condition>, IDashboardCombPageConditionRepository
    {
        private readonly ApiDashboardDbContext _context;

        public DashboardCombPageConditionRepository(ApiDashboardDbContext context) : base(context)
        {
            _context = context;
        }

        public ResponseGetAllCombPage GetAllCombPage(string page_code, string combid)
        {
            var query = from a in _context.siger_project_dashboard_page_patial
                join b in _context.siger_project_dashboard_comb_page_condition on a.page_patial_code equals b
                    .page_patial_code into temp
                from pa in temp.DefaultIfEmpty()
                where a.page_code == page_code && pa.comb_page_id == combid
                select new ResponseGetAllCombPage
                {
                    page_patial_code = a.page_patial_code,
                    x = a.x,
                    y = a.y,
                    w = a.w,
                    h = a.h,
                    page_patial_condition_code = pa != null ? pa.page_patial_condition_code : "",
                    condition = pa != null ? pa.condition : "",
                };
            return query.FirstOrDefault();
        }

        public ResponseGetAllData GetAllData(string patial_code, string page_id)
        {
            var query = from a in _context.siger_project_dashboard_comb_page_condition
                join b in _context.siger_project_dashboard_page_patial_condition on a.page_patial_condition_code equals
                    b.page_patial_condition_code into temp
                from pa in temp.DefaultIfEmpty()
                where a.page_patial_code == patial_code && a.comb_page_id == page_id
                select new ResponseGetAllData
                {
                    id = a.id,
                    acc_text_value = a.acc_text_value,
                    condition = a.condition,
                    right_article_num = a.right_article_num,
                    right_foot_online = a.right_foot_online,
                    right_foot_offline = a.right_foot_offline,
                    type = pa.type
                };
            return query.FirstOrDefault();
        }

        public IEnumerable<SigerTrDict> GetDictValue(string cat, int projectId)
        {
            var dict = _context.siger_tr_dict.Where(f => f.projectId == projectId && f.cat == cat  && f.status == (int)RowState.Valid);

            return dict.ToList();
        }
    }
}
