﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Data;

namespace Siger.Middlelayer.DashboardRepository.Repositories
{
    internal class DashboardCombPageRepository : DashboardRepositoryBase<siger_project_dashboard_comb_page>, IDashboardCombPageRepository
    {
        private readonly ApiDashboardDbContext _context;
        public DashboardCombPageRepository(ApiDashboardDbContext context) : base(context)
        {
            _context = context;
        }

        public int AddCombPage(int combId, string pageCode, string title)
        {
            var comb = new siger_project_dashboard_comb_page
            {
                comb_id = combId,
                page_code = pageCode,
                title = title
            };
            _context.siger_project_dashboard_comb_page.Add(comb);
            _context.SaveChanges();

            return comb.id;
        }
        /// <summary>
        /// Dashboard数据存在做修改操作---修改title
        /// </summary>
        /// <param name="combId">组合id</param>
        /// <param name="pageCode">pageCode</param>
        /// <param name="title">标题</param>
        /// <param name="page_id">页面id</param>
        public void UpdateCombPage(int combId, string pageCode, string title,int page_id)
        {
            var comb = _context.siger_project_dashboard_comb_page.Where(u=>u.comb_id==combId&&u.page_code==pageCode && u.id==page_id).FirstOrDefault();
            comb.title = title;
            _context.siger_project_dashboard_comb_page.Update(comb);
            _context.SaveChanges();
        }

        public IEnumerable<DashboardPageInfo> GetCombInfo(string pageCode)
        {
            var query = from dp in _context.siger_project_dashboard_page
                        join dpp in _context.siger_project_dashboard_page_patial on dp.page_code equals dpp.page_code into temp
                        from dpp1 in temp.DefaultIfEmpty()
                        join dppc in _context.siger_project_dashboard_page_patial_condition on dpp1.page_patial_code equals dppc
                            .page_patial_code into temp2
                        from dppc1 in temp2.DefaultIfEmpty()
                        where dp.page_code == pageCode
                        select new DashboardPageInfo
                        {
                            page_code = dp.page_code,
                            page_patial_code = dpp1 != null ? dpp1.page_patial_code : "",
                            x = dpp1 != null ? dpp1.x : 0,
                            y = dpp1 != null ? dpp1.y : 0,
                            w = dpp1 != null ? dpp1.w : 0,
                            h = dpp1 != null ? dpp1.h : 0,
                            page_patial_condition_code = dppc1 != null ? dppc1.page_patial_condition_code : "",
                            type = dppc1 != null ? dppc1.type : 0,
                            des = dppc1 != null ? dppc1.des : "",
                        };

            return query.AsEnumerable();
        }

        public IEnumerable<DashboardPageForEdit> GetEditConditionForEdit(int combPageId, int projectId)
        {
            var query = from cpc in _context.siger_project_dashboard_comb_page_condition
                        join cp in _context.siger_project_dashboard_comb_page on cpc.comb_page_id equals cp.id.ToString()
                        join c in _context.siger_project_dashboard_comb on cp.comb_id equals c.id
                        join p in _context.siger_project_dashboard_page on cp.page_code equals p.page_code
                        join pp in _context.siger_project_dashboard_page_patial on cpc.page_patial_code equals pp.page_patial_code
                        join ppc in _context.siger_project_dashboard_page_patial_condition on cpc.page_patial_condition_code equals ppc.page_patial_condition_code
                        where cp.id == combPageId && c.status == (int)RowState.Valid && c.project_id == projectId
                        select new DashboardPageForEdit
                        {
                            condition_id = cpc.id,
                            page_patial_code = cpc.page_patial_code,
                            page_patial_condition_code = cpc.page_patial_condition_code,
                            condition = cpc.condition,
                            acc_text_value = cpc.acc_text_value,
                            right_article_num = cpc.right_article_num,
                            right_foot_online = cpc.right_foot_online,
                            right_foot_offline = cpc.right_foot_offline,
                            type = ppc.type,
                            title = cp.title,
                            page_code = cp.page_code,
                            comb_title = c.title,
                            img_url = p.img_url,
                            des = ppc.des,
                            w = pp.w,
                            h = pp.h,
                            x = pp.x,
                            y = pp.y
                        };

            return query.AsEnumerable();
        }
    }
}
