﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Data;
using static Siger.Middlelayer.DashboardRepository.Response.ResponseDashboardRotation;

namespace Siger.Middlelayer.DashboardRepository.Repositories
{
    internal class DashboardCombRepository : DashboardRepositoryBase<siger_project_dashboard_comb>, IDashboardCombRepository
    {
        private readonly ApiDashboardDbContext _context;
        public DashboardCombRepository(ApiDashboardDbContext context) : base(context)
        {
            _context = context;
        }

        public int GetPageIdByCode(string code)
        {
            var query = from q in _context.siger_project_dashboard_page_patial
                join p in _context.siger_project_dashboard_page on q.page_code equals p.page_code
                where q.page_patial_code == code && q.status == (int) RowState.Valid
                select p.id;
            return query.FirstOrDefault();
        }

        public IEnumerable<DashboardComb> GetDashboardCombs(int projectId)
        {
            var query = from dc in _context.siger_project_dashboard_comb
                join dcp in _context.siger_project_dashboard_comb_page on dc.id equals dcp.comb_id
                where dc.project_id == projectId && dc.status == (int) RowState.Valid && dc.id == dcp.comb_id
                select new DashboardComb
                {
                    comb_id = dc.id,
                    page_code = dcp != null ? dcp.page_code : "",
                    page_id = dcp != null ? dcp.id : 0,
                    page_title = dcp != null ? dcp.title : ""
                };
            return query.ToList();
        }

        public IEnumerable<siger_project_dashboard_comb_page_Rotation> GetCombPages(int comboId, int projectId)
        {
            var query = from dc in _context.siger_project_dashboard_comb
                        join dcp in _context.siger_project_dashboard_comb_page on dc.id equals dcp.comb_id into comb
                        from dcp1 in comb.DefaultIfEmpty()
                        where dc.project_id == projectId && dc.status == (int)RowState.Valid && dc.id == dcp1.comb_id && dcp1.comb_id == comboId
                        select new siger_project_dashboard_comb_page_Rotation
                        {
                            id=dcp1.id,
                            comb_id=dcp1.comb_id,
                            page_code=dcp1.page_code,
                            title=dcp1.title,
                            status=dcp1.status,
                            cycle=dc.cycle
                        };

                        //select dcp1;

            return query.ToList();
        }
    }
}
