﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Request
{
    public class RequestSigerTrCjrfList
    {
        public List<RequestSigerTrCjrfAlarmTop5> alarm { get; set; }
        public List<RequestTimeEfficiencyTop10List> efficiency { get; set; }
        public RequestTimeEfficiency timeefficiency { get; set; }
        public List<RequestRealtimeAlarmList> timealarm { get; set; }
        public RequestDeviceStatusSummaryData device { get; set; }
        public List<RequestDeviceRealTimeStatusList> realtime { get; set; }
        public RequestDeviceStatusDistributeData distribute { get; set; }
    }
    public class RequestSigerTrCjrfAlarmTop5
    {
        /// <summary>
        /// 工位
        /// </summary>
        public string station { get; set; }
        /// <summary>
        /// 持续时长
        /// </summary>
        public int duration { get; set; }
    }
    public class RequestTimeEfficiencyTop10List
    {
        /// <summary>
        /// 工位
        /// </summary>
        public string station { get; set; }
        /// <summary>
        /// 百分比
        /// </summary>
        public string percent { get; set; }
    }

    public class RequestTimeEfficiency
    {
        /// <summary>
        /// 时间稼动率
        /// </summary>
        public string timeEfficiencyV { get; set; }
    }

    public class RequestRealtimeAlarmList
    {
        /// <summary>
        /// 工位
        /// </summary>
        public string station { get; set; }
        /// <summary>
        /// 报警内容
        /// </summary>
        public string alarmContent { get; set; }
        /// <summary>
        /// 持续时长
        /// </summary>
        public int duration { get; set; }
    }

    public class RequestDeviceStatusSummaryData
    {
        /// <summary>
        /// 运行设备数量
        /// </summary>
        public int runNum { get; set; }
        /// <summary>
        /// 调试设备数量
        /// </summary>
        public int debugNum { get; set; }
        /// <summary>
        /// 空闲设备数量
        /// </summary>
        public int freeNum { get; set; }
        /// <summary>
        /// 报警设备数量
        /// </summary>
        public int errorNum { get; set; }
        /// <summary>
        /// 关机设备数量
        /// </summary>
        public int closeNum { get; set; }
    }
    public class RequestDeviceStatusDistributeData
    {
        /// <summary>
        /// 运行时长
        /// </summary>
        public int hour1 { get; set; }
        /// <summary>
        /// 调试时长
        /// </summary>
        public int hour2 { get; set; }
        /// <summary>
        /// 空闲时长
        /// </summary>
        public int hour3 { get; set; }
        /// <summary>
        /// 报警时长
        /// </summary>
        public int hour4 { get; set; }
        /// <summary>
        /// 关机时长
        /// </summary>
        public int hour5 { get; set; }
    }
    public class RequestDeviceRealTimeStatusList
    {
        /// <summary>
        /// 工位
        /// </summary>
        public string station { get; set; }
        /// <summary>
        /// 设备编号
        /// </summary>
        public string deviceNo { get; set; }
        /// <summary>
        /// 设备名称
        /// </summary>
        public string deviceName { get; set; }
        /// <summary>
        /// 设备用途
        /// </summary>
        public string devicePurpose { get; set; }
        /// <summary>
        /// 设备报警信息
        /// </summary>
        public string deviceWarn { get; set; }
        /// <summary>
        /// 持续时长
        /// </summary>
        public int duration { get; set; }
        /// <summary>
        /// 横坐标
        /// </summary>
        public int x { get; set; }
        /// <summary>
        /// 纵坐标
        /// </summary>
        public int y { get; set; }
        /// <summary>
        /// 类型
        /// </summary>
        public int type { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public int current_status { get; set; }
    }
}
