﻿using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.Share.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseProjectKpiItem : KpiEntityBase
    {
        /// <summary>
        /// 部门ID :siger_project_section.id
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// 父级Id
        /// </summary>
        public int ParentId { get; set; }

        /// <summary>
        /// 指标周期
        /// </summary>
        public Share.ModuleEnum.KpiCycleEnum KpiCycle { get; set; }
        /// <summary>
        /// KPI项目
        /// </summary>
        public string Item { get; set; }
        /// <summary>
        /// 目标值
        /// </summary>
        public double TargetVal { get; set; }
        /// <summary>
        /// 单位
        /// </summary>
        public string Unit { get; set; }
        /// <summary>
        /// 条件 0:大于 1 ：小于
        /// </summary>
        public int Condition { get; set; }
        /// <summary>
        /// 大屏位置---废弃
        /// </summary>
        public int Position { get; set; }
        /// <summary>
        /// 大屏背景颜色---废弃
        /// </summary>
        public string Color { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int Creater { get; set; }

        public DateTime CreateTime { get; set; }
        public int projectId { get; set; }
    }

    public class ResponseKpiTasklist : KpiEntityBase
    {
        /// <summary>
        /// 日期 2019-12-31
        /// </summary>
        public DateTime Busidate { get; set; }
        /// <summary>
        /// 部门
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// item id
        /// </summary>
        public int ItemId { get; set; }
        /// <summary>
        /// 实际值
        /// </summary>
        public double ActVal { get; set; }
        /// <summary>
        /// KPI 任务状态  1 未配置 2 异常  3:正常
        /// </summary>
        public KpiTaskResult Result { get; set; } = KpiTaskResult.NoConfg;

        /// <summary>
        /// 异常任务 状态 ：1:未处理，2 处理中，3 处理完成
        /// </summary>
        public KpiExecption Excption { get; set; }
        /// <summary>
        /// 任务类型：0 正常，1 异常
        /// </summary>
        public int Type { get; set; }

        public int projectId { get; set; }

        /// <summary>
        /// 周期
        /// </summary>
        public string cycle { get; set; }
        public string Remark { get; set; }
        public double TargetVal { get; set; }
        public double AddVal { get; set; }
    }
}
