﻿using Siger.Middlelayer.QmsRepository.Entities;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseQmsReworkData : QmsEntityBase
    {
        public int Section_Id { get; set; }
        public string Sn { get; set; }
        public int Product_Id { get; set; }

        public int Material_Id { get; set; }
        /// <summary>
        /// 返工前工序 / 工位
        /// </summary>
        public int preroute_id { get; set; }
        /// <summary>
        /// 当前工站
        /// </summary>
        public int Route_Id { get; set; }
        /// <summary>
        /// 1:单件  2：整箱
        /// </summary>
        public int SnType { get; set; }

        public int OQC_Id { get; set; }
        // public string OQC_Item { get; set; }
        public string Remark { get; set; }
        public DateTime DateTime { get; set; }

        /// <summary>
        /// 1:维修  2：报废
        /// </summary>
        public int Type { get; set; }
        public int User_Id { get; set; }
        /// <summary>
        /// 产品数量
        /// </summary>
        public int Count { get; set; }
    }


    public class ResponseInspectioner : QmsEntityBase
    {
        public long trace_id { get; set; }

        /// <summary>
        /// 检测室字典key
        /// </summary>
        public string testroom { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int productid { get; set; }

        public int materialid { get; set; }

        /// <summary>
        /// 工位ID
        /// </summary>
        public int sectionid { get; set; }

        /// <summary>
        /// 二维码
        /// </summary>
        public string sn { get; set; }

        /// <summary>
        /// 工序ID
        /// </summary>
        public int routeid { get; set; }

        /// <summary>
        /// 检验类型 1->首检2->巡检3->末检4->标准件检
        /// </summary>
        public int check_type { get; set; }

        /// <summary>
        /// 1->待接收2->检测完成3->待检验4->检验中
        /// </summary>
        public int check_status { get; set; }

        /// <summary>
        /// 结果
        /// </summary>
        public string result { get; set; }

        /// <summary>
        /// 送检人
        /// </summary>
        public int send_mid { get; set; }

        /// <summary>
        /// 送检时间
        /// </summary>
        public DateTime send_time { get; set; }

        /// <summary>
        /// 检验人
        /// </summary>
        public int check_mid { get; set; }

        /// <summary>
        /// 检验时间
        /// </summary>
        public DateTime? check_time { get; set; }

        /// <summary>
        /// 扩展表类别 1->送检检验2->人工检验
        /// </summary>
        public int inspection_type { get; set; }

        public int number { get; set; }
        /// <summary>
        /// 送检原因
        /// </summary>
        public string reason { get; set; }

        public string workorder { get; set; }
        /// <summary>
        /// 偏差放行数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 接收人
        /// </summary>
        public int recieve_mid { get; set; }
        /// <summary>
        /// 接收时间
        /// </summary>
        public DateTime? recieve_time { get; set; }
        /// <summary>
        /// 开始检验人
        /// </summary>
        public int checking_mid { get; set; }
        /// <summary>
        /// 开始检验时间
        /// </summary>
        public DateTime? checking_time { get; set; }
    }

    public class ResponseTraceDetail : QmsEntityBase
    {
        [Key]
        public long ID { get; set; }

        public int MachineID { get; set; }

        public long TraceID { get; set; }

        public string SN { get; set; }

        public int ItemID { get; set; }

        public string ItemName { get; set; }

        public double? Value { get; set; }

        public string Result { get; set; }

        public DateTime CreateTime { get; set; }

        public double? LowerLimit { get; set; }

        public double? UpperLimit { get; set; }

        public int NumberIndex { get; set; }

        /// <summary>
        /// 异常状态 存 abnomal_rule表的key
        /// </summary>
        public string abnomal_status { get; set; }
    }

    public class ResponseTraceMaterial : QmsEntityBase
    {
        public int SectionID { get; set; }

        public int ProductID { get; set; }

        public int SupplierID { get; set; }

        public int MaterialID { get; set; }

        public string PartNumber { get; set; }

        public string BatchNumber { get; set; }

        public int TotalQuantity { get; set; }

        public int RandomCheckNumber { get; set; }

        public string Result { get; set; }

        public int UserID { get; set; }

        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 来料二维码
        /// </summary>
        public string SN { get; set; }

        public string PO { get; set; }
        /// <summary>
        /// 到货日期
        /// </summary>
        public DateTime? ArrivalDate { get; set; }

        public string Remark { get; set; }
    }

    public class ResponseTraceMaterialDetail : QmsEntityBase
    {
        public int TraceID { get; set; }

        public string SN { get; set; }

        public int ItemID { get; set; }

        public string ItemName { get; set; }

        public double? Value { get; set; }

        public string Result { get; set; }

        public int UserID { get; set; }

        public DateTime CreateTime { get; set; }

        public int NumberIndex { get; set; }

        public double? UpperLimit { get; set; }

        public double? LowerLimit { get; set; }
    }
}
