﻿using System.Collections.Generic;
using Siger.Middlelayer.Common;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseRigStatusMonitor
    {
        public void Add(ResponseMachineStatus machine)
        {
            if (Machines == null)
            {
                Machines = new List<ResponseMachineStatus>();
            }
            Machines.Add(machine);
        }
        public string Target { get; set; }
        public string Monthly { get; set; }
        public string Actual { get; set; }
        public string Actual_YTD { get; set; }
        public List<ResponseMachineStatus> Machines { get; set; }

        public string machine_count { get; set; }

        public string today_time { get; set; }

    }
    public class ResponseMachineStatus
    {
        public string name { get; set; }
        public string code { get; set; }
        public int mid { get; set; }
        public int RunState { get; set; }
        public int MaintenanceState { get; set; }
        public int SensorState { get; set; }
        public string h { get; set; } = "0";
        public string w { get; set; } = "0";
        public string x { get; set; } = "0";
        public string y { get; set; } = "0";
        public string v { get; set; } = "0";
    }

    public class ResponsKpiTrend
    {
        public ResponsKpiTrend()
        {
            X = new List<string>();
            Y1 = new List<double>();
            Y2 = new List<double>();
        }
        public List<string> X { get; set; }
        public List<double> Y1 { get; set; }
        public List<double> Y2 { get; set; }
    }
}
