﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseSum
    {
        public ResponseSum()
        {
            QmsCount = new List<ResponseSumQmsDataCount>();
            QmsPerson = new List<ResponseSumQmsDataCount>();
            QmsPersonData = new List<ResponseSumQmsDataCount>();
            AndonCount = new List<ResponseSumAndonDataCount>();
            AndonType = new List<ResponseSumAndonDataCount>();
            AndonPersonData = new List<ResponseSumAndonDataCount>();
            AndonExcepTimeBySection = new List<ResponseSumAndonExcepTime>();
            AndonExcepTimeByDepart = new List<ResponseSumAndonExcepTime>();
            AndonExcepTimeByPerson = new List<ResponseSumAndonExcepTime>();
            traceData = new List<ResponseSumTraceData>();
            KpisInfo = new List<ResponseSumKpi>();
            TpmInfoOrder = new List<ResponseSumTpm>();
            TpmInfoPerson = new List<ResponseSumTpm>();
        }
        /// <summary>
        /// 1 质量 通道数据量
        /// </summary>
        public List<ResponseSumQmsDataCount> QmsCount { get; set; }

        /// <summary>
        /// 2 质量 通道操作人数
        /// </summary>
        public List<ResponseSumQmsDataCount> QmsPerson { get; set; }

        /// <summary>
        /// 3 质量 人员数量录入
        /// </summary>
        public List<ResponseSumQmsDataCount> QmsPersonData { get; set; }
        /// <summary>
        /// 4 安灯操作数量
        /// </summary>
        public List<ResponseSumAndonDataCount> AndonCount { get; set; }

        /// <summary>
        /// 5 安灯异常类别
        /// </summary>
        public List<ResponseSumAndonDataCount> AndonType { get; set; }
        /// <summary>
        /// 6 安灯人员数据
        /// </summary>
        public List<ResponseSumAndonDataCount> AndonPersonData { get; set; }

        /// <summary>
        /// 7 异常处理时长--通道
        /// </summary>
        public List<ResponseSumAndonExcepTime> AndonExcepTimeBySection { get; set; }

        /// <summary>
        /// 8  异常处理时长--部门
        /// </summary>
        public List<ResponseSumAndonExcepTime> AndonExcepTimeByDepart { get; set; }

        /// <summary>
        /// 9  异常处理时长--人员
        /// </summary>
        public List<ResponseSumAndonExcepTime> AndonExcepTimeByPerson { get; set; }

        /// <summary>
        /// 10 追溯
        /// </summary>
        public List<ResponseSumTraceData> traceData { get; set; }

        /// <summary>
        /// 11 KPI 信息
        /// </summary>
        public List<ResponseSumKpi>KpisInfo { get; set; }

        /// <summary>
        /// 12 设备模块工单量
        /// </summary>
        public List<ResponseSumTpm> TpmInfoOrder { get; set; }

        /// <summary>
        /// 13 设备模块操作人数
        /// </summary>
        public List<ResponseSumTpm> TpmInfoPerson { get; set; }


    }

    /// <summary>
    ///各质量模块 1,2,3 
    /// </summary>
    public class ResponseSumQmsDataCount
    {
        public int id { get; set; }
        /// <summary>
        /// 通道ID
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// 通道名称
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 进料检验
        /// </summary>
        public int IncomInspect { get; set; }
        /// <summary>
        /// 过程检验
        /// </summary>
        public int ProcessInspect { get; set; }
        /// <summary>
        /// 检验室送检
        /// </summary>
        public int LabInspect { get; set; }
        /// <summary>
        /// 检验室送检
        /// </summary>
        public int LabInspectCompalte { get; set; }
        /// <summary>
        /// 返工
        /// </summary>
        public int Rework { get; set; }
        /// <summary>
        /// 报废
        /// </summary>
        public int Waste { get; set; }
    }

    /// <summary>
    /// 安灯模块通道操作数量 4,5,6
    /// </summary>
    public class ResponseSumAndonDataCount
    {
        public int Section { get; set; }
        /// <summary>
        /// 通道
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 触发数量
        /// </summary>
        public int Trigger { get; set; }
        /// <summary>
        /// 签到数量
        /// </summary>
        public int Sign { get; set; }
        /// <summary>
        /// 完成数量
        /// </summary>
        public double Done { get; set; }
        /// <summary>
        /// 复线数量
        /// </summary>
        public double Redo { get; set; }
        /// <summary>
        /// 完成率  = 复线数量 / 触发数量
        /// </summary>
        public string RateOfDone { get; set; } 
    }

    
    /// <summary>
    /// 安灯异常处理7,8,9
    /// </summary>
    public class ResponseSumAndonExcepTime
    {
        public string Title { get; set; }
        /// <summary>
        /// 平均响应时长
        /// </summary>
        public double AvgAction { get; set; }
        /// <summary>
        /// 平均处理时长
        /// </summary>
        public double AvgWorking { get; set; }
        /// <summary>
        /// 平均复线时长
        /// </summary>
        public double AvgReWork { get; set; }
    }


    public class ResponseSumTraceData
    {
        public string Title { get; set; }
        /// <summary>
        /// 单品追溯
        /// </summary>
        public int Sigle { get; set; }
        /// <summary>
        /// 批次追溯
        /// </summary>
        public int Batch { get; set; }
    }
    /// <summary>
    /// 
    /// </summary>
    public class ResponseSumKpi
    {
        /// <summary>
        /// 部门
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// KPI 正常
        /// </summary>
        public int Normal { get; set; }
        /// <summary>
        /// KPI 异常
        /// </summary>
        public int Exception { get; set; }
        /// <summary>
        /// KPI 为维护
        /// </summary>
        public int NotCfg { get; set; }
        /// <summary>
        /// 为分配行动计划
        /// </summary>
        public int NotAction { get; set; }
        /// <summary>
        /// 行动计划延迟
        /// </summary>
        public int LateAction { get; set; }
        /// <summary>
        /// 行动计划未关闭
        /// </summary>
        public int Pending { get; set; }
        /// <summary>
        /// 行动计划关闭
        /// </summary>
        public int Closed { get; set; }
    }

    public class ResponseSumTpm
    {
        public string Title { get; set; }
        /// <summary>
        /// 维修接单
        /// </summary>
        public int Repairt { get; set; }
        /// <summary>
        /// 维修签到
        /// </summary>
        public int Sign { get; set; }
        /// <summary>
        /// 维修完成
        /// </summary>
        public int Done { get; set; }
        /// <summary>
        /// 计划维护
        /// </summary>
        public int Plan { get; set; }
        /// <summary>
        /// 计划维护完成
        /// </summary>
        public int PlanDone { get; set; }
        /// <summary>
        /// 备件流动
        /// </summary>
        public int PlanPart { get; set; }
    }
}
