﻿using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.TpmRepository.Entities;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseToolPreparationList
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string OrderNumber { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string ProductName { get; set; }
        /// <summary>
        /// 设备名称
        /// </summary>
        public string MachineName { get; set; }
        /// <summary>
        /// 物料名称
        /// </summary>
        public string MaterialName { get; set; }
        /// <summary>
        /// 刀位号
        /// </summary>
        public string ToolLocation { get; set; }
        /// <summary>
        /// 需求时间
        /// </summary>
        public string NeedTime { get; set; }
        /// <summary>
        /// 领用人
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 推荐库位
        /// </summary>
        public string Location { get; set; }
        /// <summary>
        /// 当前库存
        /// </summary>
        public int Count { get; set; }
    }

    public class ResponseToolUseChart
    {
        public List<string> X { get; set; } = new List<string>();
        public List<int> Y { get; set; } = new List<int>();
    }

    public class ResponseGetTooLifeData
    {
        /// <summary>
        /// 设备名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 刀位
        /// </summary>
        public string Location { get; set; }
        /// <summary>
        /// 寿命
        /// </summary>
        public double ToolLife { get; set; }
        public double ToolLife2 { get; set; }
        /// <summary>
        /// 道具编号
        /// </summary>
        public string ToolNumber { get; set; }
        public string ToolNumber2 { get; set; }
        public ChannelState State { get; set; }
    }
}
