﻿using System.Collections;
using System.Collections.Generic;
using Siger.Middlelayer.DncRepository.Entities;
using Siger.Middlelayer.DncRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.DncRepository.Repositories.Interface
{
    public interface ISigerProjectDncUserPowerRepository : IDncRepositoryBase<siger_project_dnc_user_power>
    {
        ResponseCheckButtons GetCheckbuttons( int userId);
        IEnumerable GetCheckUsers(int projectId);
        IEnumerable GetProducts(int projectId);
        IEnumerable GetsectionLists(int projectId);
        IEnumerable GetUsers(int projectId, int? sectionid);
        bool AddPower(int projectId, int userId, int mid, int add_power, int del_power, int check_power, int all_power, string remark);
        ResponseUserPowerInfo GetPowerUserInfo(int projectId, int powerid);
        bool EditPower( int userId,  int powerid, int add_power, int del_power, int check_power, int all_power, string remark, int projectId);
        bool DelPower(int userId, int powerid);
        IEnumerable GetPowerLists(int projectId, int? sectionID, int page, int pagesize, out int totalCount);
        IEnumerable<ResponseProgramList> GetProgramLists(int projectId, int userId,string programcode, string product_name, int checkstatus, int page, int pagesize, out int totalCount);
        void AddProgramPost(int projectId,int userId, string file_url, string file_name, string file_size, string programcode, int productid, int checkmid, string createremark);
        /// <summary>
        /// /// <summary>
        /// 判断用户是否具有管理员权限或全部操作权限
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        /// </summary>
        bool CheckPower(int userId);

        bool HasEditPower(int userId);

        bool HasDeletePower(int userId);

        bool HasApprovalPower(int userId);

        IPagedCollectionResult<ResponseProgramList> GetProgramLists(int projectId, int userId, string createmid, string checkmid, string product, int page, int pagesize, int starttime, int endtime);
        IPagedCollectionResult<ResponseProgramsList> GetMainProgramLists(int projectId, int userId, string productId, string processCode, string programCode, int checkStatus, int page, int pagesize);
        IPagedCollectionResult<ResponseProgramsList> GetMainProgramListChecked(int projectId, int userId, string keywords, string createBy, string checkBy, int startDate, int endDate, int page, int pagesize);
        IPagedCollectionResult<ResponseVersionRecord> GetProgramVersionInfo(string programCode,int userId,int projectId,int page,int pagesize);
        IPagedCollectionResult<ResponseProgramsList> GetMainProgramList(int projectId, int userId, string keywords, string createBy, string checkBy, int startDate, int endDate, int product_id, int route_id, int page, int pagesize);
    }
}
