﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.DncRepository.Request
{
    public class RequestCheckProgramPost
    {
        /// <summary>
        /// 程序id
        /// </summary>
        [Required(ErrorMessage = "ProgramidNotNull")]
        public int programid { get; set; }

        /// <summary>
        /// 程序号
        /// </summary>
        [Required(ErrorMessage = "ProgramNoNotNull")]
        public string programcode { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string check_remark { get; set; }

        /// <summary>
        /// 1通过，2不通过
        /// </summary>
        public int num { get; set; }
    }

    public class RequestCheckProgramPosts
    {
        /// <summary>
        /// 程序
        /// </summary>
        public IEnumerable<CheckProgram> programids { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string check_remark { get; set; }

        /// <summary>
        /// 1通过，2不通过
        /// </summary>
        public int num { get; set; }
    }

    public class RequestCheckPrograms
    {
        /// <summary>
        /// 程序
        /// </summary>
        public List<CheckProgram> programids { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string check_remark { get; set; }

        /// <summary>
        /// 1通过，2不通过
        /// </summary>
        public int num { get; set; }
    }

    public class RequestCheckProgramsNew
    {
        /// <summary>
        /// 程序
        /// </summary>
        public int programids { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string check_remark { get; set; }

        /// <summary>
        /// 1通过，2不通过
        /// </summary>
        public int num { get; set; }
    }

    public class CheckProgram
    {
        public int programid { get; set; }

        public string programcode { get; set; }
    }
}
