﻿using System.Collections.Generic;

namespace Siger.Middlelayer.DncRepository.Request
{
   public class RequestEditProgram
    {
        /// <summary>
        /// 程序id
        /// </summary>
        public int programid { get; set; }

        /// <summary>
        /// 文件路径
        /// </summary>
        public string file_url = "";

        /// <summary>
        /// 文件名称
        /// </summary>
        public string file_name = "";

        /// <summary>
        /// 文件大小
        /// </summary>
        public int file_size { get; set; }

        /// <summary>
        /// 程序号
        /// </summary>
        public string programcode = "";

        /// <summary>
        /// 产品id
        /// </summary>
        public int productid { get; set; }

        /// <summary>
        /// 审核人员mid
        /// </summary>
        public int checkmid { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string createremark = "";
    }

    public class RequestEditProgramGaoLang: RequestEditProgram
    {
        public string drawno = "";
        public string workproccess = "";
    }

    public class RequestReturnProgram
    {
        public int sectionid { get; set; }
        /// <summary>
        /// 路卡号
        /// </summary>
        public string gateNo { get; set; }
        /// <summary>
        /// 程序号
        /// </summary>
        public string program { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string productName { get; set; }
        /// <summary>
        /// 文件夹名
        /// </summary>
        public string filename { get; set; }
        public string fileurl { get; set; }
        public string filesize { get; set; }
        public int productid { get; set; }
        public List<string> data { get; set; }

        /// <summary>
        /// 审核人mid
        /// </summary>
        public int checkmid { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public int checktime { get; set; } = 0;

        /// <summary>
        /// 审核备注
        /// </summary>
        public string check_remark { get; set; }

        /// <summary>
        /// 审核结果1通过2不通过
        /// </summary>
        public int checkinfo { get; set; }

        /// <summary>
        /// 审核状态1待审核2已审核3被拒绝
        /// </summary>
        public int checkstatus { get; set; }


        public string process_code { get; set; }

        public string machine_code { get; set; }

        public string program_version { get; set; }
    }


    public class RequestReturnPrograms
    {
        public int sectionid { get; set; }
        /// <summary>
        /// 程序号
        /// </summary>
        public string program { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string productName { get; set; }
        public int machine_id { get; set; }

        public int product_id { get; set; }
        public int route_id { get; set; }
    }
}
