﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.EsopRepository
{
    public class ApiEsopDbContext : DbContext
    {
        public ApiEsopDbContext(DbContextOptions<ApiEsopDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_project_esop_process> siger_project_esop_process { get; set; }

        public DbSet<siger_project_esop_process_set> siger_project_esop_process_set { get; set; }

        public DbSet<siger_project_esop_document_set> siger_project_esop_document_set { get; set; }

        public DbSet<siger_project_esop_document> siger_project_esop_document { get; set; }

        public DbSet<siger_project_esop_document_history> siger_project_esop_document_history { get; set; }

        public DbSet<siger_project_esop_document_approval> siger_project_esop_document_approval { get; set; }

        public DbSet<siger_project_esop_document_binding> siger_project_esop_document_binding { get; set; }

        public DbSet<siger_project_section> siger_project_section { get; set; }

        public DbSet<siger_project_user> siger_project_user { get; set; }

        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }

        public DbSet<siger_project_product> siger_project_product { get; set; }

        public DbSet<siger_project_machine> siger_project_machine { get; set; }

        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }

        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }

        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }

        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_qms_sensor_parameterEx> siger_qms_sensor_parameter { get; set; }
    }
}
