﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.EsopRepository.Repositories.Interface;
using Siger.Middlelayer.EsopRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.EsopRepository.Repositories
{
    internal class EsopDocumentSetRepository : EsopRepositoryBase<siger_project_esop_document_set>, IEsopDocumentSetRepository
    {
        private readonly ApiEsopDbContext _context;
        public EsopDocumentSetRepository(ApiEsopDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetDocumentSetList> GetDocumentSetList(int projectId, int page, int pagesize)
        {
            var querylist = from q in _context.siger_project_esop_document_set
                join u in _context.siger_project_user on q.creator_mid equals u.mid
                where q.project_id == projectId && q.status == (int) RowState.Valid orderby q.create_time descending
                select new ResponseGetDocumentSetList
                {
                    id = q.id,
                    create_time = q.create_time.ToString("yyyy-MM-dd"),
                    creator_name = u.name,
                    name = q.name,
                    need_train = q.need_train,
                    process_id = q.process_id,
                    sign_usergroup_id = q.sign_usergroup_id,
                    usergroup_ids = q.usergroup_ids
                };

            var totalCount = querylist.Count();
            var entities = querylist.Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            var response = new List<ResponseGetDocumentSetList>();
            foreach (var document in entities)
            {
                var data = Mapper<ResponseGetDocumentSetList, ResponseGetDocumentSetList>.Map(document);
                if (data.process_id != 0)
                {
                    var process = _context.siger_project_esop_process.FirstOrDefault(q => q.id == data.process_id);
                    if (process != null)
                    {
                        data.process_name = process.name;
                    }
                }
                if (data.sign_usergroup_id != 0)
                {
                    var section = _context.siger_project_usergroup.FirstOrDefault(q => q.id == data.sign_usergroup_id);
                    if (section != null)
                    {
                        data.sign_usergroup_name = section.title;
                    }
                }

                if (!string.IsNullOrWhiteSpace(data.usergroup_ids))
                {
                    var list = data.usergroup_ids.Split(',');
                    var usergroups = _context.siger_project_usergroup.Where(q => list.Contains(q.id.ToString())).ToList();
                    if (usergroups.Any())
                    {
                        data.usergroup_names = string.Join(",", usergroups.Select(m => m.title));
                    }
                }

                response.Add(data);
            }

            return new PagedCollectionResult<ResponseGetDocumentSetList>(response, totalCount);
        }
    }
}
