﻿using System.Collections.Generic;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.EsopRepository.Request;
using Siger.Middlelayer.EsopRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.EsopRepository.Repositories.Interface
{
    public interface IEsopDocumentBindingRepository : IEsopRepositoryBase<siger_project_esop_document_binding>
    {
        IPagedCollectionResult<ResponseGetDocumentBinding> GetDocumentBindingList(int product_id, int level_id, int page, int pagesize, int projectId);

        IPagedCollectionResult<GetMachinePagedBinding> GetMachinePagedBinding(int project_id, IEnumerable<int> machineIds, int page, int pagesize);

        IPagedCollectionResult<ResponseGetRouteBinding> GetRouteDocumentBindingList(string starttime, string endtime,
            int product_id, int level_id, int projectId, int page, int pagesize);

        IEnumerable<int> GetBindIds(int product_id, int level_id, int projectId);

        bool AddBindDetail(RequestUpdateDocumentStatus request, int projectId, int userId);

        /// <summary>
        /// 文档使用记录，按产线查询
        /// </summary>
        /// <param name="starttime"></param>
        /// <param name="endtime"></param>
        /// <param name="product_id"></param>
        /// <param name="level_id"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IPagedCollectionResult<ResponseSearchDocumentBinding> SearchDocumentBinding(string starttime, string endtime,
            int product_id, int level_id,
            int page, int pagesize, int projectId);

        /// <summary>
        ///文档使用记录，按设备查询
        /// </summary>
        /// <param name="starttime"></param>
        /// <param name="endtime"></param>
        /// <param name="machineIds"></param>
        /// <param name="keyword"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IPagedCollectionResult<ResponseSearchDocumentBinding> SearchDocumentBindingByMachine(string starttime,
            string endtime, IEnumerable<int> machineIds, string keyword, int page, int pagesize, int projectId);

        /// <summary>
        /// 文档签收记录
        /// </summary>
        /// <param name="machineIds"></param>
        /// <param name="status"></param>
        /// <param name="projectId"></param>
        /// <param name="userId"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        IPagedCollectionResult<ResponseGetDocumentSignList> GetDocumentSignList(IEnumerable<int> machineIds, int status,
            int projectId, int userId, int page, int pagesize);

        /// <summary>
        /// 现场展示查询
        /// </summary>
        /// <param name="machineIds"></param>
        /// <param name="type_id"></param>
        /// <param name="document_name"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<ResponseShowDocumentBinding> ShowDocumentBindings(IEnumerable<int> machineIds, int type_id, string document_name, int projectId);
    }
}
