﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.EsopRepository.Request;
using Siger.Middlelayer.EsopRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.EsopRepository.Repositories.Interface
{
    public interface IEsopProcessRepository : IEsopRepositoryBase<siger_project_esop_process>
    {
        IPagedCollectionResult<ResponseGetEsopProcess> GetPagedList(int projectId, int page, int pagesize);

        bool AddProcess(RequestAddProcess request, int userId, int projectId);

        IEnumerable<siger_project_esop_process_set> GetEsopProcessSets(int processId);

        void UpdateEsopProcessSets(int processId, IEnumerable<ApprovalUserGroup> groups);

        IEnumerable<ResponseGetProcessFlow> GetProcessFlows(int process_id);

        IEnumerable<ResponseApprovalHistory> GetResponseApprovalHistories(int document_id, int process_id);
        IQueryable<siger_project_esop_process_set> GetAllEsopProcessSets();
    }
}
