﻿using System;
using Siger.Middlelayer.Common.FieldEnum;

namespace Siger.Middlelayer.IMSRepository.Entities
{
    public class siger_project_ims_package : IMSEntityBase
    {
        /// <summary>
        /// 位置
        /// </summary>
        public string location { get; set; }

        /// <summary>
        /// 组装的刀柄编号
        /// </summary>
        public string assemble_code { get; set; }

        /// <summary>
        /// 组装条码，序列号或者序号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// boom刀具号
        /// </summary>
        public string boom_code { get; set; }

        /// <summary>
        /// 是否确认
        /// </summary>
        public ChoiceStatus confirm_status { get; set; } = ChoiceStatus.UnApply;

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int create_id { get; set; }

        /// <summary>
        /// 测量状态
        /// </summary>
        public MeasureResult measure_status { get; set; } = MeasureResult.Unmeasured;

        /// <summary>
        /// 实际直径
        /// </summary>
        public double actual_diameter { get; set; }

        /// <summary>
        /// 实际刀长
        /// </summary>
        public double actual_length { get; set; }

    }
}
