using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;
using Siger.Middlelayer.IMSRepository.Request;
using Siger.Middlelayer.Utility.ImportEntities;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Response;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.IMSRepository;

namespace Siger.MiddlelayerIMSRepository.Repositories
{
    public class ProjectIMSTestRepository : RepositoryBase<ProjectIMSTestEntity>, IProjectIMSTestRepository
    {
        private readonly ApiIMSDbContext _context;
        public ProjectIMSTestRepository(ApiIMSDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ProjectIMSTestEntity> GetPagedList(RequestProjectIMSTest req)
        {
            //todo:根据实际业务构建查询条件
            Expression<Func<ProjectIMSTestEntity, bool>> conditionCommon = q => q.Status == (int)RowState.Valid && q.Projectid == req.ProjectId;;
            var predicates = conditionCommon;
            var totalCount = _context.ProjectIMSTestEntities.Count(predicates);
            List<ProjectIMSTestEntity> entities;
            if (req.Page != 0)
            {
                entities = _context.ProjectIMSTestEntities.Where(predicates).OrderByDescending(o=>o.Id).Skip((req.Page - 1) * req.PageSize).Take(req.PageSize).AsNoTracking().ToList();
            }
            else
            {
                entities = _context.ProjectIMSTestEntities.Where(predicates).OrderByDescending(o=>o.Id).AsNoTracking().ToList();
            }
            return new PagedCollectionResult<ProjectIMSTestEntity>(entities, totalCount);

        }
    }
}
