﻿using System;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;

namespace Siger.Middlelayer.IMSRepository.Repositories
{
    internal class ToollifeCabinetReceiveDetailRepository : IMSRepositoryBase<SigerProjectIMSCabinetReceiveDetail>, IToollifeCabinetReceiveDetailRepository
    {
        private readonly ApiIMSDbContext _context;
        public ToollifeCabinetReceiveDetailRepository(ApiIMSDbContext context) : base(context)
        {
            _context = context;
        }

        public int InsertCabinetReceiveDetailData(SigerProjectIMSCabinetReceiveDetail data)
        {
            try
            {
                _context.siger_project_ims_cabinet_receive_detail.Add(data);
                return _context.SaveChanges();
            }
            catch (Exception e)
            {
                Logger.WriteLineError(e.Message);
                return 0;
            }
        }
    }
}
