﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.IMSRepository.Response
{
    public class ResponeGetToolItem
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 编号
        /// </summary>
        public string number { get; set; }

        /// <summary>
        /// 类别id
        /// </summary>
        public int category_id { get; set; }

        /// <summary>
        /// 类别名称
        /// </summary>
        public string category_name { get; set; }

        /// <summary>
        /// 料号
        /// </summary>
        public string part_no { get; set; }

        public string image { get; set; }

        public string image_name { get; set; }

        public string video { get; set; }

        /// <summary>
        /// 是否修磨 1是 2不是
        /// </summary>
        public int grind { get; set; }

        /// <summary>
        /// 修磨次数
        /// </summary>
        public int grind_times { get; set; }

        /// <summary>
        /// 修磨方式 1自主修磨 2外协修磨
        /// </summary>
        public int grind_type { get; set; }

        /// <summary>
        /// 使用次数
        /// </summary>
        public int use_times { get; set; }

        public int material_id { get; set; }

        public IList<ToolParamterInfo> GeometryParameter { get; set; }

        public IList<ToolParamterInfo> TechnologyParameter { get; set; }

        /// <summary>
        /// 1需要测试2不需要测试
        /// </summary>
        public int need_test { get; set; }
        public ResponeGetToolItem()
        {
            GeometryParameter = new List<ToolParamterInfo>();
            TechnologyParameter = new List<ToolParamterInfo>();
        }
    }

    public class ToolParamterInfo
    {
        public int para_id { get; set; }

        public string name { get; set; }

        public string unit { get; set; }

        public string code { get; set; }

        public string value { get; set; }
    }

    public class ToolItemInfo
    {
        public int id { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 编号
        /// </summary>
        public string number { get; set; }

        /// <summary>
        /// 类别id
        /// </summary>
        public int category_id { get; set; }

        public ImsSettingCategory type { get; set; }

        public int material_id { get; set; }
    }

    public class ResponseGetToolMaterialInfos
    {
        public int material_id { get; set; }

        public string part_no { get; set; }

        public string material_name { get; set; }

        /// <summary>
        /// 是否可修磨
        /// </summary>
        public int grind { get; set; }

        public int supplier_id { get; set; }

        public string supplier { get; set; }

        public string serial_number { get; set; }

        public List<ResponseKeyValue> MaterialStatus { get; set; } = new List<ResponseKeyValue>();
    }
}
