﻿using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.FieldEnum;
using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.IMSRepository.Response
{
    public class ResponseGetInstall
    {
        public string woNumber { get; set; }

        public int machine_type { get; set; }

        public string mchType { get; set; }

        /// <summary>
        /// 应该安装的刀位
        /// </summary>
        public string instllPosz { get; set; }

        public string bathNumber { get; set; }

        public string handler_code { get; set; }

        public int machineId { get; set; }

        public IList<PositionList> poszList { get; set; }

        public ResponseGetInstall()
        {
            poszList = new List<PositionList>();
        }
    }

    public class PositionList
    {
        public string cutter_number { get; set; }

        public string bathNumber { get; set; }

        public string handler_code { get; set; }

        public int install_status { get; set; }
    }

    public class ResponseGetInstallList
    {
        public int id { get; set; }

        public string section_name { get; set; }

        public string serial_number { get; set; }

        public string machine_name { get; set; }

        public string machine_id { get; set; }

        public string machine_code { get; set; }

        public string cutter_number { get; set; }

        public string install_user { get; set; }

        public string install_time { get; set; }
        public int process_count { get; set; }
        public string tool_life { get; set; }
        public string tool_name { get; set; }
        public string tool_number { get; set; }
        public int tool_type { get; set; }
    }

    public class ResponseGetInstallDetail
    {
        public string machine_code { get; set; }

        public string cutter_number { get; set; }

        public string categroy { get; set; }

        public int material_id { get; set; }

        public string material_name { get; set; }

        public string supplier { get; set; }

        public int quantity { get; set; }
    }

    public class ResponseGetUnInstallImage
    {
        public List<string> x { get; set; } = new List<string>();

        public List<int> y { get; set; } = new List<int>();
    }

    public class ResponseGetInstallStock
    {
        public int tool_id { get; set; }

        public string pn { get; set; }

        public int material_id { get; set; }

        public int stock_id { get; set; }

        public int bussiness_id { get; set; }

        public string bussiness_name { get; set; }

        public string reason { get; set; }

        public DateTime unistall_time { get; set; }
    }

    public class NameCount
    {
        public int count { get; set; }

        public string name { get; set; }
    }

    public class ResponseToolUseData
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }
        public int package_id { get; set; }
        /// <summary>
        /// 刀位号
        /// </summary>
        public string Position { get; set; }
        /// <summary>
        /// 加工件数
        /// </summary>
        public string ProcessCount { get; set; }
        public string SerialNo { get; set; }
        public string MaterialCode { get; set; }
        public string Supplier { get; set; }
        public string Location { get; set; }
        public string Name { get; set; }
        public string Reason { get; set; }
        public string Installer { get; set; }
        public string machine_code { get; set; }
        public int uid { get; set; }
        public int mid { get; set; }
        public DateTime InstallTime { get; set; }
        public DateTime UninstallTime { get; set; }
    }

    public class ResponseToolProcessData
    {
       public string Name { get; set; }
       public string Material { get; set; }
       public string Supplier { get; set; }
       public string Location { get; set; }
        /// <summary>
        /// 断刀
        /// </summary>
       public int Broken { get; set; }
        /// <summary>
        /// 磨损
        /// </summary>
       public int Collapse { get; set; }
        /// <summary>
        /// 崩刃
        /// </summary>
       public int Damage { get; set; }
       public int Count { get; set; }
       public int ProcessCount { get; set; }
       public int Mid { get; set; }
        
    }

    public class ResponseGetToolUseCount
    {
        public string name { get; set; }

        public string work_code { get; set; }

        public int collar_number { get; set; }

        public int cabinet_number { get; set; }

        public int install_number { get; set; }

        public double proportion { get; set; }
    }

    public class ToolLifeConfigData
    {
        public List<int> toolids { get; set; }
        public string Location { get; set; }

    }

    public class ResponseToolInstallInfo
    {
        /// <summary>
        /// 设备
        /// </summary>
        public string machineName { get; set; }
        public int id { get; set; }
        /// <summary>
        /// 设备编号
        /// </summary>
        public string machineCode { get; set; }
        public int materialId { get; set; }
        public int businessId { get; set; }
        /// <summary>
        /// 刀位
        /// </summary>
        public string toolLocaltion { get; set; }
        /// <summary>
        /// 道具编号
        /// </summary>
        public string toolCode { get; set; }
        /// <summary>
        /// 刀具条形码
        /// </summary>
        public string serialNumber { get; set; }
        /// <summary>
        /// 刀具名称
        /// </summary>
        public string toolName { get; set; }
        /// <summary>
        /// 安装时间
        /// </summary>
        public string installTime { get; set; }
        public DateTime createtime { get; set; }
        /// <summary>
        /// 安装人员
        /// </summary>
        public string installUser { get; set; }
        public int installUserId { get; set; }
        /// <summary>
        /// 卸载时间
        /// </summary>
        public string uninstallTime { get; set; }
        /// <summary>
        /// 卸载原因
        /// </summary>
        public string uninstallReason { get; set; }
        /// <summary>
        /// 加工件数？
        /// </summary>
        public string life { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }
        public ImsSettingCategory category { get; set; }
    }

    public class ResponseToolLifeAnalysis
    {
        /// <summary>
        /// 额定寿命
        /// </summary>
        public List<int> y1 { get; set; } = new List<int>();
        /// <summary>
        /// 实际寿命
        /// </summary>
        public List<int> y2 { get; set; } = new List<int>();
        /// <summary>
        /// 刀具条码
        /// </summary>
        public List<string> x { get; set; } = new List<string>();
        /// <summary>
        /// 数据明细
        /// </summary>
        public List<ResponseToolLifeAnalysisDetail> detail { get; set; } = new List<ResponseToolLifeAnalysisDetail>();
    }
    public class ResponseToolLifeAnalysisDetail
    {
        /// <summary>
        /// 刀具条码
        /// </summary>
        public string serialNumber { get; set; }
        /// <summary>
        /// 额定寿命
        /// </summary>
        public int ratedLife { get; set; }
        /// <summary>
        /// 实际寿命
        /// </summary>
        public int actualLife { get; set; }
    }
}
