﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.KpiRespository
{
    public class ApiKpiDbContext : DbContext
    {
        public ApiKpiDbContext()
        {

        }
        public ApiKpiDbContext(DbContextOptions<ApiKpiDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }
        public DbSet<siger_project_section> siger_project_section { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<SigerProjectKpiTasklist> siger_project_kpi_tasklist { get; set; }
        public DbSet<siger_project_kpi_item> siger_project_kpi_item { get; set; }
        public DbSet<SigerProjectKpiAction> siger_project_kpi_action { get; set; }
        public DbSet<SigerProjectKpiActionResult> siger_project_kpi_action_result { get; set; }
        public DbSet<SigerProjectKpiPushSetting> siger_project_kpi_push_setting { get; set; }
        public DbSet<siger_project_plan_report> siger_project_plan_report { get; set; }
        public DbSet<siger_project_plan_report_level> siger_project_plan_report_level { get; set; }
        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }
        public DbSet<SigerProjectKpiTaskMessage> siger_project_kpi_push_msg { get; set; }
        public DbSet<siger_app_project_config> siger_app_project_config { get; set; }
        public DbSet<siger_system_config> siger_system_config { get; set; }
        public DbSet<siger_app_project_user> siger_app_project_user { get; set; }
        public DbSet<siger_app_project_message> siger_app_project_message { get; set; }
        public DbSet<SigerProjectKpiItemDisplayPosition> siger_project_kpi_item_display_position { get; set; }
        public DbSet<SigerProjectKpiDisplaySetting> siger_project_kpi_item_display_setting { get; set; }
        public DbSet<SigerProjectKpiIAutoCalculation> siger_project_kpi_auto_calculation { get; set; }
        public DbSet<siger_project_kpi_authority> siger_project_kpi_authority { get; set; }
    }
}
