﻿using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository.Respose;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Siger.Middlelayer.Common;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Extensions;
using Microsoft.EntityFrameworkCore;

namespace Siger.Middlelayer.KpiRespository.Repositories
{
    internal class KpiPushSettingRepository : KpiRepositoryBase<SigerProjectKpiPushSetting>, ISigerKpiPushSetting
    {
        private ApiKpiDbContext kpiDbContext;
        public KpiPushSettingRepository(ApiKpiDbContext context) : base(context)
        {
            kpiDbContext = context;
        }

        public IPagedCollectionResult<ResponsePushSetting> GetKPIPushSettingList(int section, int item, int projectid, int page, int pagesize)
        {

            Expression<Func<ResponsePushSetting, bool>> FunSection = f => true;
            Expression<Func<ResponsePushSetting, bool>> FunItem = f => true;

            var query = from s in kpiDbContext.siger_project_kpi_push_setting
                       join d in kpiDbContext.siger_project_section on s.section_id equals d.id
                       join i in kpiDbContext.siger_project_kpi_item on s.kpi_item equals i.id
                       join u in kpiDbContext.siger_project_user on s.user_id equals u.mid into temp
                       from us in temp.DefaultIfEmpty()
                       where s.projectId == projectid && s.status == (int)RowState.Valid
                       select new ResponsePushSetting
                       {
                           Id=s.id,
                           ProcessCode=s.process_code,
                           DepartId=d.id,
                           Depart=d.title,
                           KpiItemId=i.id,
                           KpiItem=i.Item,
                           Refresh=s.repeattime,
                           DateTime=s.datetime,
                           Remarks=s.remark,
                           User=us!=null?us.name:s.user_id.ToString()
                       };
            if (section != 0)
                FunSection = f => f.DepartId == section;
            if (item!=0)
                FunItem = f => f.KpiItemId==item;

            var predicate = FunSection.And(FunItem);
            var totalCount = query.Count(predicate);
            var entities = query.Where(predicate).OrderByDescending(q => q.Id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<ResponsePushSetting>(entities, totalCount);
      
        }

        public string GetSectionDesc(List<int> sections, int project)
        {
            var query = from u in kpiDbContext.siger_project_usergroup
                        where sections.Contains(u.id)
                        select new ResponseUserGroup
                        {
                             Id=u.id,
                             Name=u.title
                        };

            var usergroup = query.ToList();

            var desc = string.Empty;
            foreach (var u in usergroup)
                desc += "->" + u.Name;

            return desc;

        }
    }
}
