﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Linq;
using System.Linq.Expressions;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class CheckMessageRepository : QMSRepositoryBase<siger_qms_check_message>, ICheckMessageRepository
    {
        private readonly ApiQmsDbContext _context;
        public CheckMessageRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ReponseCheckMessage> GetPagedList(string status, int userid, int projectId, int page, int pagesize)
        {
            var rowstate = (int)RowState.Valid;
            var query = _context.siger_qms_check_message.Where(q => q.projectid == projectId && q.tomid == userid);
            var querylist = from q in query
                            join p in _context.siger_check_sn_trace_inspection on q.checkid equals p.id
                            join u1 in _context.siger_project_user on p.send_mid equals u1.mid
                            join u2 in _context.siger_project_user on p.check_mid equals u2.mid
                            join s1 in _context.siger_project_level_section on p.sectionid equals s1.id
                            into ss1
                            from s1 in ss1.DefaultIfEmpty()
                            join s2 in _context.siger_project_level_section on s1.parentid equals s2.id
                            into ss2
                            from s2 in ss2.DefaultIfEmpty()
                            where p.check_status == (int)SendCheckStatus.Completed
                            select new ReponseCheckMessage
                            {
                                id = q.id,
                                checkid = q.checkid,
                                sectionid = p.sectionid,
                                senduser = u1.name,
                                sendtime = p.send_time.ToString(ParameterConstant.DateTimeFormat),
                                checkuser = u2.name,
                                checktime = (p.check_time.HasValue && p.check_time != DateTime.MinValue) ? 
                                    p.check_time.Value.ToString(ParameterConstant.DateTimeFormat) : "",
                                checkresult = p.result,
                                createtime = q.createtime,
                                section = s1.title,
                                parentsection = s2.title,
                                readstate = q.readstate,
                                status = q.status
                            };

            Expression<Func<ReponseCheckMessage, bool>> statusExpression = f => true;
            Expression<Func<ReponseCheckMessage, bool>> readstateExpression = f => true;
            if (!string.IsNullOrEmpty(status))
            {
                if (status.ToInt() == 2)
                {
                    statusExpression = f => f.status == (int)RowState.Invalid;
                }
                if (status.ToInt() == 0 || status.ToInt() == 1)
                {
                    readstateExpression = f => f.readstate == status.ToInt() && f.status == rowstate;
                }
            }            
            var expression = statusExpression.And(readstateExpression);

            var totalCount = querylist.Count(expression);
            var entities = querylist.Where(expression).OrderByDescending(t => t.createtime)
                .Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ReponseCheckMessage>(entities, totalCount);
        }

        public int GetUnReadCount(int userid, int projectId)
        {
            var query = _context.siger_qms_check_message.Where(q => q.projectid == projectId && q.tomid == userid &&
                q.status == (int)RowState.Valid && q.readstate == 0);
            var querylist = from q in query
                            join p in _context.siger_check_sn_trace_inspection on q.checkid equals p.id
                            join u1 in _context.siger_project_user on p.send_mid equals u1.mid
                            join u2 in _context.siger_project_user on p.check_mid equals u2.mid
                            select q;
            var totalCount = querylist.Count();
            return totalCount;
        }
    }
}
