﻿using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using System.Linq;
using System.Linq.Expressions;
namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class CheckSnListRepository : QMSRepositoryBase<siger_check_sn_list>, ICheckSnListRepository
    {
        private readonly ApiQmsDbContext _context;
 

        public CheckSnListRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public ResponseProductSn GetProductBySn(string sn, int projectId)
        {
            var query = from s in _context.siger_check_sn_list
                        join p in _context.siger_project_product on s.ProductID equals p.id
                        where s.projectid == projectId && s.SN == sn && s.status == (int)RowState.Valid
                        select new ResponseProductSn
                        {
                            Sn = s.SN,
                            ProductId = p.id,
                            ProductName = p.name
                        };

            return query.FirstOrDefault();
        }
    }
}
