﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class InspectCategoryRepository : QMSRepositoryBase<siger_qms_inspection_unhealthy_category>, IInspectCategoryRepository
    {
        private readonly ApiQmsDbContext _context;
        public InspectCategoryRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseInspectCategory> GetPagedList(int parentid, int projectid, int page, int pagesize)
        {
            var query0 = _context.siger_qms_inspection_unhealthy_category.Where(q =>
                q.status == (int) RowState.Valid && q.projectid == projectid && q.parentid == 0);

            var querylist0 = from q in query0
                select new ResponseInspectCategory
                {
                    id = q.id,
                    pid = q.parentid,
                    name = q.name,
                    pname = ""
                };

            var query1 = _context.siger_qms_inspection_unhealthy_category.Where(q =>
                q.status == (int) RowState.Valid && q.projectid == projectid
                                                 && q.parentid != 0);
            var querylist1 = from q in query1
                join p in _context.siger_qms_inspection_unhealthy_category on q.parentid equals p.id
                    into temp
                from tt in temp.DefaultIfEmpty()
                select new ResponseInspectCategory
                {
                    id = q.id,
                    pid = q.parentid,
                    name = q.name,
                    pname = tt.name ?? ""
                };


            Expression<Func<ResponseInspectCategory, bool>> parentidExpression = q => true;
            if (parentid > 0) // 取全部子级
            {
                var ids = GetSonCategorys(parentid, projectid).Select(t => t.id).ToList();
                ids.Add(parentid);
                parentidExpression = q => ids.Contains(q.id);
            }

            var predicate = parentidExpression;

            var entities = querylist0.Union(querylist1).Where(predicate).AsNoTracking().ToList();
            var totalCount = entities.Count;
            var list = entities.OrderBy(q => q.pid).Skip((page - 1) * pagesize).Take(pagesize);

            return new PagedCollectionResult<ResponseInspectCategory>(list, totalCount);
        }

        public IEnumerable<siger_qms_inspection_unhealthy_category> GetSonCategorys(int parentId, int projectid)
        {
            var query = from c in _context.siger_qms_inspection_unhealthy_category
                where c.parentid == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonCategorys(t.id, projectid)));
        }
    }
}
