﻿using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Response;
using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.QmsRepository.Repositories.Interface
{
    public interface IQmsRepositoryBase<TEntity> : IRepositoryBase<TEntity> where TEntity : QmsEntityBase
    {
        string GetDictValue(int projectId, string cat, string dkey);

        string GetLevelSectionTitleBySectionId(int sectionId, int projectId);

        string GetProductNameByCode(string productCode, int projectId);

        SigerTrRoutingEventNo GetEventNoByResult(string result, int projectId);

        SigerTrRoutingOutStation GetOutStationByEventNo(int eventno, int sectionId, int projectId);

        IEnumerable<ResponseIdName> GetSectionRouteList(string productcode, int sectionid, int projectid);

        ResponseIdName GetMachineBySectionId(int sectionId, int projectId);

        IEnumerable<ResponseSonMaterials> GetSonMaterialsByProductId(int projectId, int productId);

        bool InsertKpiTaskList(SigerProjectKpiTasklist entity);

        SigerProjectKpiItem GetKpiItem(string item, int projectid);

        int GetKpiTaskCount(int section, int itemid, string cycle, DateTime stime, DateTime etime, int projectid);

        bool UpdateKpiTaskList(SigerProjectKpiTasklist item);

        string WorkOrderGenerator(int projectid);

        siger_andon_expection_type GetAndonExceptionType(string exceptionType, int parentid, int projectid);

        bool InsertAndonInfo(siger_andon_info entity);

        bool InsertAndonDetailInfo(siger_andon_info_detail entity);

    }
}
