﻿using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.QmsRepository.Repositories.Interface
{
    public interface IQmsReworkDataRepository :  IQmsRepositoryBase<siger_qms_rework_data>
    {
        IPagedCollectionResult<ResponseRepairData> GetRepairPagedList(List<int> sectionId, int materialId, int productId, int preRoute, int route,int section,string sn,DateTime begin,DateTime end , int reworkType, int projectId, int page, int pagesize);

        IPagedCollectionResult<ResponseRepairData> GetReworkPagedList(List<int> sectionId, int materialId, int productId, int preRoute, int route, int section, string sn, DateTime begin, DateTime end, int projectId, int page, int pagesize);
        IPagedCollectionResult<ResponseRepairData> GetWastePagedList(List<int> sectionId, int materialId, int productId, int preRoute, int route, int section, string sn, DateTime begin, DateTime end, int projectId, int page, int pagesize);
        IEnumerable<ResponseProductRoute> GetRouteBySn(string sn,int Route_Id,int projectId);
        IEnumerable<ResponseProductRoute> GetPreRouteBySn(string sn, int Route_Id, int projectId);

        ResponseSnMaterial GetSnList(string Sn, int projectId);
        IEnumerable<ResponseRepairData> GetRepairAllData(List<int> sectionId, int materialId, int productId, int preRoute, int route, int section, string sn, DateTime begin, DateTime end, int reworkType, int projectId);
        IEnumerable<ResponseWasteInfo> GetWasteAnalysisData(int materialId, int productId, DateTime begin, DateTime end, int projectId);

        IEnumerable<ResponseProductItem> GetOQCItemBysn(int projectId,string sn);


        /// <summary>
        /// 报废品分析数据源
        /// </summary>
        /// <param name="sections"></param>
        /// <param name="productId"></param>
        /// <param name="projectId"></param>
        /// <param name="starttime"></param>
        /// <param name="endtime"></param>
        /// <returns></returns>
        IEnumerable<ResponseWasteData> GetResponseWaste(List<int> sections, int productId, int projectId, DateTime starttime, DateTime endtime);
        List<ResponseReworkData> GetReworkData(List<int> sections, int projectId, DateTime starttime, DateTime endtime);
    }
}
