﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.QmsRepository.Repositories.Interface
{
    public interface IQmsSensorParameterRepository : IQmsRepositoryBase<siger_qms_sensor_parameter>
    {
        CommonImportResult ImportInspectDataCountValue(IEnumerable<SensorParameter> standards, int projectid, int userid);

        IPagedCollectionResult<siger_qms_sensor_parameter> GetSensorParameterData(int projectId, int type, string code, int mid,
            int lastdtStart, int lastdtEnd, int nextdtStart, int nextdtEnd, int page, int pagesize);

        IPagedCollectionResult<ResponseSensorDetailData> GetSensorDetailData(int projectId, int type, string code, int mid,
            int lastdtStart, int lastdtEnd, int nextdtStart, int nextdtEnd, int page, int pagesize, int status, int check, int appove,
            string model, int id, int check2);

        int CalTimeStamp(CycleUnit unit, double cycle);

        string CreateSensorCode(int projectid);
    }
}
