﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class QmsBarcodeBatchRepository : QMSRepositoryBase<siger_qms_barcode_batch>, IQmsBarcodeBatchRepository
    {
        private readonly ApiQmsDbContext _context;
        public QmsBarcodeBatchRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<RespoonseBarcodeBatch> GetPagedList(int stationid, string duns, string barcode, string starttime,
            string endtime, int page, int pagesize, int toexcel)
        {
            var query = from q in _context.siger_qms_barcode_batch
                join p in _context.siger_qms_barcodegun_set on q.barcodegun_id equals p.id
                where q.status == (int) RowState.Valid
                select new RespoonseBarcodeBatch
                {
                    id = q.id,
                    barcode = q.barcode,
                    barcodegun_id = p.id,
                    acc_code = q.acc_code,
                    duns = q.duns,
                    feeding_time = q.feeding_time,
                    feeding_time_str = q.feeding_time.ToString(ParameterConstant.DateTimeFormat),
                    heat = q.heat,
                    matrix = q.matrix,
                    part_number = q.part_number,
                    produce_time = q.produce_time,
                    produce_time_str = q.produce_time.ToString(ParameterConstant.DateFormat),
                    quantity = q.quantity,
                    supplier = q.supplier,
                    steel_route = q.steel_route,
                    station_name = p.station_name
                };

            Expression<Func<RespoonseBarcodeBatch, bool>> stationExpression = f => true;
            if (stationid != 0)
            {
                stationExpression = f => f.barcodegun_id == stationid;
            }
            Expression<Func<RespoonseBarcodeBatch, bool>> dunsExpression = f => true;
            if (!string.IsNullOrWhiteSpace(duns))
            {
                dunsExpression = f => f.duns == duns;
            }
            Expression<Func<RespoonseBarcodeBatch, bool>> barcodeExpression = f => true;
            if (!string.IsNullOrWhiteSpace(barcode))
            {
                stationExpression = f => f.barcode.Contains(barcode);
            }
            Expression<Func<RespoonseBarcodeBatch, bool>> starttimeExpression = f => true;
            if (!string.IsNullOrWhiteSpace(starttime))
            {
                stationExpression = f => f.feeding_time >= starttime.ToDateTime();
            }
            Expression<Func<RespoonseBarcodeBatch, bool>> endtimeExpression = f => true;
            if (!string.IsNullOrWhiteSpace(endtime))
            {
                endtimeExpression = f => f.feeding_time <= endtime.ToDateTime();
            }
            var predicates = stationExpression.And(dunsExpression).And(barcodeExpression).And(starttimeExpression).And(endtimeExpression);

            if (toexcel == 0)
            {
                var total = query.Count(predicates);
                var entities = query.Where(predicates).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).ToList();
                return new PagedCollectionResult<RespoonseBarcodeBatch>(entities, total);
            }

            return new PagedCollectionResult<RespoonseBarcodeBatch>(query.Where(predicates).OrderByDescending(q => q.id).ToList(), 0);
        }
    }
}
