﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class QmsSensorTypeRepository : QMSRepositoryBase<siger_qms_sensor_type>, IQmsSensorTypeRepository
    {
        private readonly ApiQmsDbContext _context;
        public QmsSensorTypeRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public string GetSensorTypeString(int pid, int typeid)
        {
            var typeModel = _context.siger_qms_sensor_type.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && f.id.Equals(typeid)).FirstOrDefault();
            if (typeModel == null)
            {
                return null;
            }
            return GetSensorTypeString(pid, typeModel.parentid)+ "->"+ typeModel.title;
        }

        public List<ResponseSensorFileData> GetSensorFile(string fid)
        {
            var ret = new List<ResponseSensorFileData>();
            var fileModel = _context.siger_qms_sensor_file.Where(f => f.fid.Equals(fid) && f.status != (int)RowState.Invalid).ToList();
            if (fileModel.Any())
            {
                var model = Mapper<siger_qms_sensor_file, ResponseSensorFileData>.MapList(fileModel);
                ret.AddRange(model);
            }
            return ret;
        }
    }
}
