﻿using System.Collections.Generic;
using System;

namespace Siger.Middlelayer.QmsRepository.Response
{
    public class ResponseSensorParameterData
    {
        public string sensor_code { get; set; }
        public string name { get; set; }
        public int typeid { get; set; }
        public int parentid { get; set; }
        public string factory_label { get; set; }
        public string model { get; set; }
        public string range { get; set; }
        public int cycle_unit { get; set; }
        public string cycle_unit_value { get; set; }
        public string machine { get; set; }
        public string type { get; set; }
        public double cycle { get; set; }
        public int alarm { get; set; }
        public int mid { get; set; }
        public string marktime { get; set; }
        public string approvetime { get; set; }
        public string nextmarktime { get; set; }
        public string result { get; set; }
        public string resttime { get; set; }
        public string user { get; set; }
        public string state { get; set; }
        public int id { get; set; }
        public int station { get; set; }
        public int status { get; set; }

        public string sensor_status { get; set; }
        public string factory_precision { get; set; }
        public string acceptable_precision1 { get; set; }
        public string acceptable_precision2 { get; set; }
        public string acceptable_precision3 { get; set; }
        public string acceptable_precision4 { get; set; }
        public string acceptable_precision5 { get; set; }
        public string mark_place { get; set; }
        public string external_system { get; set; }
        public string bind_manual { get; set; }
        public string validation_manual { get; set; }
        public string standard_procedure1 { get; set; }
        public string standard_procedure2 { get; set; }
        public string temperature { get; set; }
        public string remark { get; set; }
        public string humidity { get; set; }
        public string position { get; set; }
        public string[] qualities { get; set; }
        public string quality { get; set; }
        public string calibration_source { get; set; }
        public string sensor1 { get; set; }
        public string sensor2 { get; set; }
        public string sensor3 { get; set; }
        public string sensor4 { get; set; }
        public int verification { get; set; }
        public int mark_uid { get; set; }
        public string mark_user { get; set; }
        public int nextmark_type { get; set; }
    }

    public class ResponseSensorType
    {
        public ResponseSensorType()
        {
            file = new List<ResponseSensorFileData>();
            validation_file = new List<ResponseSensorFileData>();
        }
        public string title { get; set; }
        public string parent { get; set; }
        public int parentid { get; set; }
        public List<ResponseSensorFileData> file { get; set; }
        public List<ResponseSensorFileData> validation_file { get; set; }
        public string fid { get; set; }
        public int id { get; set; }
    }
    public class ResponseSensorTypeTree
    {
        public string title { get; set; }
        public List<ResponseSensorTypeTree> children { get; set; }
        public int id { get; set; }
        public int parentid { get; set; }
        public bool disabled { get; set; } = false;
        public bool spread { get; set; } = true;
    }
    public class ResponseSensorParam
    {
        public int id { get; set; }
        public string validation_manual { get; set; }
        public string standard_procedure { get; set; }
    }
    public class ResponseSensorFileData
    {
        public string file_name { get; set; }
        public string file_url { get; set; }
        public int id { get; set; }
    }

    public class ResponseSensorDetailData : ResponseSensorParameterData
    {
        public ResponseSensorDetailData()
        {
            if (file == null)
            {
                file = new List<ResponseSensorFileData>();
            }
            if (history == null)
            {
                history = new List<ResponseSensorFileData>();
            }
        }
        public DateTime upload_time { get; set; }
        public DateTime approve_time { get; set; }
        public int mark_time { get; set; }
        public int checkuser { get; set; }
        public int checkuser2 { get; set; }
        public int approvaluser { get; set; }
        public int nexttime { get; set; }
        public string fid { get; set; }
        public int markuser { get; set; }
        public string markuser_value { get; set; }
        public string checkuser_value { get; set; }
        public string checkuser2_value { get; set; }
        public string approvaluser_value { get; set; }
        public List<ResponseSensorFileData> file { get; set; }

        public int appearance { get; set; }
        public int label { get; set; }
        public string supplier { get; set; }
        public string history_fid { get; set; }
        public string history_result { get; set; }
        public string report_type { get; set; }
        public List<ResponseSensorFileData> history { get; set; }
    }
    public class ResponseSensorSummary
    {
        public ResponseSensorSummary()
        {
            if (Equipments == null)
            {
                Equipments = new List<EquipmentSensor>();
            }
        }
        public int NoSet { get; set; }
        public int WaitMark { get; set; }
        public int Marking { get; set; }
        public int Normal { get; set; }
        public int OverDue { get; set; }
        public List<EquipmentSensor> Equipments { get; set; }

    }
    public class EquipmentSensor
    {
        public int mid { get; set; }
        public string Equipment { get; set; }
        public List<ResponseSensorParameterData> Sensor { get; set; }
    }
    public class ResponseSensorReport
    {
        public string sensor_code { get; set; }
        public string name { get; set; }
        public string type { get; set; }
        public int typeid { get; set; }
        public string model { get; set; }
        public string station { get; set; }
        public int station_value { get; set; }
        public string equipment { get; set; }
        public int equipment_value { get; set; }
        public string position { get; set; }
        public string marktime { get; set; }
        public int marktime_value { get; set; }
        public string upload_time { get; set; }
        public string nextmarktime { get; set; }
        public int nextmarktime_value { get; set; }
        public string bind_manual { get; set; }
        public string validation_manual { get; set; }
        public string standard_procedure1 { get; set; }
        public string standard_procedure2 { get; set; }
        public string temperature { get; set; }
        public string humidity { get; set; }
        public string acceptable_precision1 { get; set; }
        public string acceptable_precision2 { get; set; }
        public string acceptable_precision3 { get; set; }
        public string acceptable_precision4 { get; set; }
        public string acceptable_precision5 { get; set; }
        public string calibration_source { get; set; }
        public string calibration_source_name { get; set; }
        public string calibration_marktime { get; set; }
        public string calibration_nextmarktime { get; set; }
        public string calibration_range { get; set; }
        public string calibration_factory_precision { get; set; }
        public string calibration_file_name { get; set; }
        public string sensor1_source { get; set; }
        public string sensor1_source_name { get; set; }
        public string sensor1_marktime { get; set; }
        public string sensor1_nextmarktime { get; set; }
        public string sensor1_range { get; set; }
        public string sensor1_factory_precision { get; set; }
        public string sensor1_file_name { get; set; }
        public string sensor2_source { get; set; }
        public string sensor2_source_name { get; set; }
        public string sensor2_marktime { get; set; }
        public string sensor2_nextmarktime { get; set; }
        public string sensor2_range { get; set; }
        public string sensor2_factory_precision { get; set; }
        public string sensor2_file_name { get; set; }
        public string sensor3_source { get; set; }
        public string sensor3_source_name { get; set; }
        public string sensor3_marktime { get; set; }
        public string sensor3_nextmarktime { get; set; }
        public string sensor3_range { get; set; }
        public string sensor3_factory_precision { get; set; }
        public string sensor3_file_name { get; set; }
        public string sensor4_source { get; set; }
        public string sensor4_source_name { get; set; }
        public string sensor4_marktime { get; set; }
        public string sensor4_nextmarktime { get; set; }
        public string sensor4_range { get; set; }
        public string sensor4_factory_precision { get; set; }
        public string sensor4_file_name { get; set; }
        public string file_name { get; set; }
        public string bind_pass { get; set; }
        public string bind_warn { get; set; }
        public string bind_notpass { get; set; }
        public string history_file { get; set; }
        public string history_result { get; set; }
        public string history_scrap { get; set; }
        public string history_reapir { get; set; }
        public string history_accept { get; set; }
        public string history_change { get; set; }

        public string appearance { get; set; }
        public string label { get; set; }
        public string remark { get; set; }
        public string user { get; set; }
        public int user_value { get; set; }
        public string checkuser { get; set; }
        public int checkuser_value { get; set; }
        public string checkuser2 { get; set; }
        public int checkuser2_value { get; set; }
        public string approvaluser { get; set; }
        public int approvaluser_value { get; set; }
        public string reporttime { get; set; }
        public string reportname { get; set; }
        public int status { get; set; }
        public int id { get; set; }
        public string fid { get; set; }
        public string historyfid { get; set; }
        public string result { get; set; }
        public string lastvalidation_failed { get; set; }
        public string lastvalidation_report { get; set; }
    }

    public class ResponseGetLastMarkTime
    {
        public int id { get; set; }

        public string code { get; set; }

        public string marktime { get; set; }
    }

    public class ResponseTodoList
    {
        public int WaitMark { get; set; }
        public int WaitAudit { get; set; }
        public string WaitAuditToken { get; set; }
        public int SecondWaitAudit { get; set; }
        public string SecondWaitAuditToken { get; set; }
        public int Audit { get; set; }
        public string AuditToken { get; set; }


    }
}
