﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.Repository
{
    public class ApiConfigDbContext : DbContext
    {
        public ApiConfigDbContext()
        {

        }

        public ApiConfigDbContext(DbContextOptions<ApiConfigDbContext> options) : base(options)
        {

        }
        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_user_power> siger_user_power { get; set; }
        public DbSet<siger_user_role_power> siger_user_role_power { get; set; }
        public DbSet<siger_user_roles> siger_user_roles { get; set; }
        public DbSet<siger_project_level> siger_project_level { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }

        public DbSet<siger_company> siger_company { get; set; }
        public DbSet<siger_industry_first> siger_industry_first { get; set; }
        public DbSet<siger_industry_second> siger_industry_second { get; set; }
        public DbSet<siger_industry_third> siger_industry_third { get; set; }
        public DbSet<siger_location_province> siger_location_province { get; set; }
        public DbSet<siger_location_city> siger_location_city { get; set; }
        public DbSet<siger_location_county> siger_location_county { get; set; }
        public DbSet<siger_level> siger_level { get; set; }
        public DbSet<siger_project> siger_project { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<siger_project_machine_type> siger_project_machine_type { get; set; }
        public DbSet<siger_project_type> siger_project_type { get; set; }

        public DbSet<siger_project_section> siger_project_section { get; set; }
        public DbSet<siger_project_shift> siger_project_shift { get; set; }
        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }

        public DbSet<siger_project_user_info_key> siger_project_user_info_key { get; set; }
        public DbSet<siger_project_user_info_value> siger_project_user_info_value { get; set; }
        public DbSet<siger_project_group> siger_project_group { get; set; }
        public DbSet<siger_project_user_group> siger_project_user_group { get; set; }
        public DbSet<siger_project_station> siger_project_station { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }

        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }

        public DbSet<siger_system_config> siger_system_config { get; set; }

        public DbSet<siger_app_project_user> siger_app_project_user { get; set; }

        public DbSet<siger_app_project_message> siger_app_project_message { get; set; }

        public DbSet<siger_app_project_config> siger_app_project_config { get; set; }

        public DbSet<siger_app_mute> siger_app_mute { get; set; }

        public DbSet<siger_project_parameter> siger_project_parameter { get; set; }

        public DbSet<siger_project_parameter_extend> siger_project_parameter_extend { get; set; }

        public DbSet<SigerTrDict> siger_tr_dict { get; set; }

        public DbSet<siger_project_line_storage> siger_project_line_storage { get; set; }

        public DbSet<siger_project_line_storage_authority> siger_project_line_storage_authority { get; set; }

        public DbSet<siger_project_dashboard_page> siger_project_dashboard_page { get; set; }

        public DbSet<siger_project_dashboard_page_patial> siger_project_dashboard_page_patial { get; set; }
        public DbSet<siger_project_dashboard_page_patial_condition> siger_project_dashboard_page_patial_condition { get; set; }

        public DbSet<siger_tr_materials> siger_tr_materials { get; set; }
        public DbSet<siger_tr_material_type> siger_tr_material_type { get; set; }

        public DbSet<SigerTrMaterialSupplier> siger_tr_material_supplier { get; set; }

        public DbSet<siger_wms_bussinese_contacts> siger_wms_bussinese_contacts { get; set; }

        public DbSet<siger_wms_area> siger_wms_area { get; set; }

        public DbSet<siger_client_version> siger_client_version { get; set; }

        public DbSet<siger_project_dashboard_project_config> siger_project_dashboard_project_config { get; set; }

        public DbSet<siger_project_monthreport_config> siger_project_monthreport_config { get; set; }
        public DbSet<siger_project_monthreport_sendrecord> siger_project_monthreport_sendrecord { get; set; }

        public DbSet<SigerProjectEmailMachine> siger_project_email_machine { get; set; }
        public DbSet<SigerProjectEmailConfig> siger_project_email_config { get; set; }
        public DbSet<siger_project_process> siger_project_process { get; set; }
        public DbSet<siger_project_product_report> siger_project_product_report { get; set; }

        public DbSet<siger_project_working_group> siger_project_working_group { get; set; }
        public DbSet<siger_project_working_calendar> siger_project_working_calendar { get; set; }
        public DbSet<siger_project_working_machine_set> siger_project_working_machine_set { get; set; }


        public DbSet<siger_project_machine_extend> siger_project_machine_extend { get; set; }
        public DbSet<siger_project_machine_node> siger_project_machine_node { get; set; }
        public DbSet<siger_project_repair_ex> siger_project_repair { get; set; }
        public DbSet<siger_project_plan_sign_ex> siger_project_plan_sign { get; set; }

        public DbSet<siger_project_machine_documentmanagement> siger_project_machine_documentmanagement { get; set; }
        public DbSet<siger_project_plan_item_ex> siger_project_plan_item { get; set; }
        public DbSet<siger_project_sparepart_ex> siger_project_sparepart { get; set; }
        public DbSet<siger_project_product_structure> siger_project_product_structure { get; set; }

        public DbSet<siger_dashboard_factory> siger_dashboard_factory { get; set; }

        public DbSet<siger_project_production_configuration> siger_project_production_configuration { get; set; }


        public DbSet<siger_project_bussinese_user> siger_project_bussinese_user { get; set; }

        public DbSet<siger_project_monthreport_config_template> siger_project_monthreport_config_template { get; set; }
        public DbSet<siger_project_dashboard_machine_group> siger_project_dashboard_machine_group { get; set; }
        public DbSet<siger_project_machine_documenttype> siger_project_machine_documenttype { get; set; }
        public DbSet<siger_project_working_cost> siger_project_working_cost { get; set; }
        public DbSet<siger_project_sparepart_recordEx> siger_project_sparepart_record { get; set; }
        public DbSet<siger_project_plan_recordEx> siger_project_plan_record { get; set; }

        public DbSet<siger_project_workinggroup_calendar> siger_project_workinggroup_calendar { get; set; }

        public DbSet<SigerTrProductStructure> siger_tr_product_structure { get; set; }

        public DbSet<siger_project_sync_config> siger_project_sync_config { get; set; }

        public DbSet<siger_project_rest_type> siger_project_rest_type { get; set; }
        //public DbSet<CommonFilesystemEntity> CommonFilesystemEntities { get; set; }

        public DbSet<FsFileinfoEntity> FsFileinfoEntities { get; set; }

        public DbSet<siger_project_config_frequency> siger_project_config_frequency { get; set; }

        public DbSet<siger_project_working_relation_user> siger_project_working_relation_user { get; set; }
        public DbSet<siger_project_working_relation_machine> siger_project_working_relation_machine { get; set; }
    }
}

