﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Repository.Data.Acc
{
    public class WorkReportInfo
    {
        public string Order { get; set; }
        public string TraceId { get; set; }
        public string Descr { get; set; }
        public string StationDesc { get; set; }
        public int Station { get; set; }
        public string PositionDesc { get; set; }
        public int Position { get; set; }
        public int Machine { get; set; }
        public int MachineId { get; set; }
        public string MachineName { get; set; }
        public string MachineCode { get; set; }
        public string WorkCode { get; set; }
        public int WorkCodeType { get; set; }
        public int WorkStaus { get; set; }
        public string Number { get; set; }
        public string ProductId { get; set; }
        public string ProductName { get; set; }
        public string ProductType { get; set; }
        public int OrderCount { get; set; }
        public int UpCount { get; set; }
        public int OkCount { get; set; }
        public int NokCount { get; set; }
        public int NokCount2 { get; set; }
        public string Remark { get; set; }
        public int Uid { get; set; }
        public string UserName { get; set; }
        public DateTime Time { get; set; }
        public string BasketId { get; set; }
        /// <summary>
        /// 需要扫描 新框
        /// </summary>
        public int Bscan { get; set; }
    }

    public class WorkCodePlanInfo
    {
        public string WorkCode { get; set; }
        public string ProductId { get; set; }
        public string ProductName { get; set; }
        public string ProductType { get; set; }
        public int OrderCount { get; set; }
    }
    /// <summary>
    /// 报工详细信息
    /// </summary>
    public class WrokCodeReport
    {
        public int id { get; set; }
        public int Station { get; set; }
        public string StationDesc { get; set; }
        public int Position { get; set; }
        public int MachineId { get; set; }
        /// <summary>
        /// 固定资产编号
        /// </summary>
        public string MachineCode { get; set; }
        /// <summary>
        /// 设备名称
        /// </summary>
        public string MachineName { get; set; }
        public string PositionDesc { get; set; }
        public string OrderNum { get; set; }
        public int OrderCount { get; set; }
        public string WorkCode { get; set; }
        public string ProductBh { get; set; }
        public string ProductName { get; set; }
        public string ProductType { get; set; }
        public string Basket { get; set; }
        public int Upload { get; set; }
        public int Report { get; set; }
        public int Ng { get; set; }
        public int Ng2 { get; set; }
        public int Type { get; set; }
        public int Status { get; set; }
        public string User { get; set; }
        public DateTime UploadTime { get; set; }
        public DateTime ReportTime { get; set; }
    }
}
