﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectMachineAttributionRepository : IApiConfigRepositoryBase<siger_project_machine_attribution>
    {
        List<ResponseGetSectionTree> GetSectionChildren(int pid, int parentid, List<siger_project_level_section> sections, int lastLevel, List<siger_project_machine_attribution> attrs, int attribution = 0);
        //CommonImportResult ImportData(IEnumerable<MachineAttribution> data, int projectId, int userId);
        CommonImportResult ImportData(IEnumerable<LevelSectionEntity> data, int projectId, int userId);
        List<ResponseGetSectionTree> GetAttributionTreeDataBySection(int pid, int parentid, List<int> stations, bool isShowSparepart = false);
        IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid);
        IEnumerable<siger_project_machine_attribution> GetParentLevelAttribution(int id, int projectid);
        List<siger_project_sparepart_ex> Getsparepart(int projectid);

        List<ResponseGetSectionTree> GetSectionTreeChildrens(int pid, int parentid, int attribution = 0, string machineLevel = "");
    }
}
