﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerTrMaterialsRepository : IApiConfigRepositoryBase<siger_tr_materials>
    {
        IPagedCollectionResult<Material> GetPagedListEx(string name, int exp, string pn, int pid, int projectid, int page,
            int pagesize);

        IEnumerable<Material> GetMaterialList(string name, int exp, int parentid, int projectid);

        CommonImportResult ImportMaterials(IEnumerable<MaterialTemplate> materials, int projectid);

        int GetMaxId();

        int InsertSupplier(SigerTrMaterialSupplier supplier);

        void UpdateSupplier(SigerTrMaterialSupplier supplier);

        void DeleteSuppliers(int materialId, int projectId);

        int InsertMaterial(siger_tr_materials material);

        int UpdateMaterial(siger_tr_materials material);

        PagedCollectionResult<Material> GetMaterialsData(string name, int exp, string pn, int typeid, int supplierId,
            int pid, int page, int pagesize);

        IEnumerable<ResponseTrMaterial> GetTrMaterialsByProductId(int projectId, int parentId);

        IEnumerable<ResponseSonMaterials> GetSonMaterialsByProductId(int projectId, int parentId);

        IEnumerable<ResponseIdName> GetSuppliersByMaterialId(int materialid, int projectId);

        IEnumerable<ResponseMaterialSupplier> GetMaterialSuppliers(int projectId);
    }
}
